package cn.gtmap.hlw.core.dto.sqxx.save;

import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/23
 * @description 批量申请信息保存聚合根
 */
@Data
public class SqxxBatchSaveModelDTO {
    /**
     * 申请类型
     */
    private String sqlx;
    /**
     * 步骤id
     */
    private String processId;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 申请信息表
     */
    private SqxxDTO sqxx;
    /**
     * 申请查封信息表
     */
    private CfxxDTO cfxx;
    /**
     * 抵押信息
     */
    private DyxxDTO dyxx;
    /**
     * 土地承包经营权
     */
    private TdcbjyDTO tdcbjy;
    /**
     * 土地承包经营权地块信息
     */
    private TdcbjydkxxDTO tdcbjyDkxx;
    /**
     * 土地经营权
     */
    private TdjyDTO tdjy;
    /**
     * 权利人
     */
    @Valid
    private List<QlrDTO> qlrList;
    /**物流信息*/
    private List<WlxxDTO> wlxxList;
    /**
     * 裁定信息
     */
    private CdxxDTO cdxx;
}
