package cn.gtmap.hlw.core.dto.sqxx.push.dj3.dyzy;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/9/5 17:22
 * @description 登记3.0 转移抵押合并流程创建入参
 */
@Data
public class PushDj3DyZyDiyixxParamsBO {

    /**
     * 地役权内容
     */
    private String dyqnr;

    /**
     * 地役权起始时间
     */
    private String dyqqssj;

    /**
     * 地役权结束时间
     */
    private String dyqjssj;

    /**
     * 附记
     */
    private String fj;

    /**
     * 不动产类型
     */
    private String bdclx;

    /**
     * 不动产类型名称
     */
    private String bdclxmc;

    /**
     * 宗地宗海面积
     */
    private String zdzhmj;

    /**
     * 宗地用途
     */
    @ZdDzConfig(field = "zdyt", tableName = ZdDzConstant.ZD_DZ_TDYT, dmToDm = true)
    private String zdyt;

    /**
     * 宗地用途名称
     */
    private String zdytmc;

    /**
     * 宗地权利性质
     */
    @ZdDzConfig(field = "zdqlxz", tableName = ZdDzConstant.ZD_DZ_QLXZ, dmToDm = true)
    private String zdqlxz;

    /**
     * 宗地权利性质名称
     */
    private String zdqlxzmc;

    /**
     * 需役地不动产单元号
     */
    private String xydbdcdyh;

    /**
     * 需役地权利人名称
     */
    private String xydqlrmc;

    /**
     * 项目id
     */
    private String xmid;

    /**
     * 供役地权利人名称
     */
    private String gydqlrmc;


    /**
     * 权利人信息
     */
    @ZdDzConfig(field = "qlrxx", tableName = "", isList = true)
    private List<PushDj3DyZyQlrxxParamsBO> qlrxx;

    /**
     * 附件信息
     */
    private List<PushDj3DyZyFjxxParamsBO> fjxx;

}
