package cn.gtmap.hlw.core.annotation;


import cn.gtmap.hlw.core.enums.SensitiveTypeEnum;

import java.lang.annotation.*;

@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface Desensitized {

    /*脱敏类型(规则)*/
    SensitiveTypeEnum type();

    /*拆分类型(分割规则，字符串拆分)*/
    String separator() default "";

    /*原先字段是否使用加密器*/
    boolean isEncrypter() default false;

    /*判断注解是否生效的方法*/
    String isEffictiveMethod() default "";

}

