/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.aop;

import cn.gtmap.hlw.core.annotation.PreAuth;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.fun.AuthFun;
import cn.gtmap.hlw.core.util.clazz.ClassUtil;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.MethodParameter;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class AuthAspect
implements ApplicationContextAware {
    private static final ExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private ApplicationContext applicationContext;

    private StandardEvaluationContext getEvaluationContext(Method method, Object[] args) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)new AuthFun());
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = ClassUtil.getMethodParameter(method, i);
            context.setVariable(methodParam.getParameterName(), args[i]);
        }
        return context;
    }

    private boolean handleAuth(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        PreAuth preAuth = ClassUtil.getAnnotation(method, PreAuth.class);
        String condition = preAuth.value();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Expression expression = SPEL_PARSER.parseExpression(condition);
            Object[] args = point.getArgs();
            StandardEvaluationContext context = this.getEvaluationContext(method, args);
            return Boolean.TRUE.equals(expression.getValue((EvaluationContext)context, Boolean.class));
        }
        return false;
    }

    @Around(value="@annotation(cn.gtmap.hlw.core.annotation.PreAuth) || @within(cn.gtmap.hlw.core.annotation.PreAuth)")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        if (this.handleAuth(point)) {
            return point.proceed();
        }
        throw new BizException(ErrorEnum.UN_AUTHORIZED);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

