package cn.gtmap.hlw.core.util.http;

import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;

import java.net.URI;

/**
 * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
 * @version 1.0, 2022-8-15.
 * @description 定义一个带body的GET请求 继承 HttpEntityEnclosingRequestBase
 */
public class HttpGetWithEntity extends HttpEntityEnclosingRequestBase {
    private static final String METHOD_NAME = "GET";

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

    public HttpGetWithEntity() {
        super();
    }

    public HttpGetWithEntity(final URI uri) {
        super();
        setURI(uri);
    }

    HttpGetWithEntity(final String uri) {
        super();
        setURI(URI.create(uri));
    }

}
