package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxCfxx;

import java.util.List;

/**
 * 在线申请--查封信息(GxYySqxxCfxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYySqxxCfxxRepository {


    /**
     * 通过ID查询单条数据
     *
     * @param cfxxid 主键
     * @return 实例对象
     */
    GxYySqxxCfxx get(Integer cfxxid);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYySqxxCfxx> getListBySlbh(String slbh);

    /**
     * 通过受理编号查询单条数据
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    GxYySqxxCfxx getBySlbh(String slbh);

    /**
     * 通过申请ID查询集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    GxYySqxxCfxx getBySqid(String sqid);

    /**
     * 新增数据
     *
     * @param gxYySqxxCfxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxCfxx gxYySqxxCfxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxCfxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxCfxx gxYySqxxCfxx);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxCfxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxCfxx gxYySqxxCfxx);

    /**
     * 批量修改或新增数据
     *
     * @param gxYySqxxCfxxList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxCfxx> gxYySqxxCfxxList);


    /**
     * 通过sqidList查询单条数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYySqxxCfxx> list(List<String> sqidList);

    /**
     * 通过cfxxidList批量删除数据
     *
     * @param cfxxidList
     * @return 实例对象
     */
    int deleteBatchIds(List<String> cfxxidList);

    /**
     * 通过sqidList批量删除数据
     *
     * @param sqidList
     * @return 实例对象
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 通过slbh删除数据
     *
     * @param slbh
     * @return 实例对象
     */
    int deleteBySlbh(String slbh);

}

