package cn.gtmap.hlw.core.model.CrossRiver;

import cn.gtmap.hlw.core.annotation.Desensitized;
import cn.gtmap.hlw.core.enums.SensitiveTypeEnum;
import cn.gtmap.hlw.core.model.GxYySqxxFyzxr;
import cn.gtmap.hlw.core.model.GxYySqxxQlrRole;
import cn.gtmap.sdk.mybatis.plugin.annotation.Crypt;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 权利人，GX_YY_QLR
 */
public class Qlr {

    /**
     * 权利人ID
     */
    private String qlrid;


    /**
     * 申请ID
     */
    private String sqid;


    /**
     * 权利人名称
     */
    @Crypt(versions = "v1.0", separator = ",")
    @Desensitized(type = SensitiveTypeEnum.CHINESE_NAME)
    private String qlrmc;


    /**
     * 权利人身份证件种类
     */
    //@DictConversion(type = DataDictUtils.table_zjlx, rule = DataDictUtils.GETMCBYDM)
    private String qlrsfzjzl;


    /**
     * 权利人证件号
     */
    @Desensitized(type = SensitiveTypeEnum.ID_CARD, isEncrypter = true)
    private String qlrzjh;


    /**
     * 权利人通讯地址
     */
    @Desensitized(type = SensitiveTypeEnum.ADDRESS)
    private String qlrtxdz;


    /**
     * 权利人类型
     */
    private String qlrlx;

    private String qlrlxmc;


    /**
     * 权利比例
     */
    private String qlbl;


    /**
     * 权利人联系电话
     */
    @Desensitized(type = SensitiveTypeEnum.MOBILE_PHONE, isEncrypter = true)
    private String qlrlxdh;


    /**
     * 适用于组合登记类型，比如“预购商品房预告、抵押权预告登记”；字典项
     */
    private String zdjlx;

    private String zdjlxmc;

    private String zjlx;


    /**
     * 代理人电话
     */
    @Desensitized(type = SensitiveTypeEnum.MOBILE_PHONE, isEncrypter = true)
    private String dlrdh;


    /**
     * 代理人名称
     */
    @Desensitized(type = SensitiveTypeEnum.CHINESE_NAME)
    @Crypt(versions = "v1.0", separator = ",")
    private String dlrmc;

    /**
     * 代理人证件号
     */
    @Desensitized(type = SensitiveTypeEnum.ID_CARD, isEncrypter = true)
    private String dlrzjh;

    /**
     * 代理人身份证件种类
     */
    //@DictConversion(type = DataDictUtils.table_zjlx, rule = DataDictUtils.GETMCBYDM)
    private String dlrsfzjzl;


    /**
     * 法定代表人或负责人电话
     */
    @Desensitized(type = SensitiveTypeEnum.MOBILE_PHONE, isEncrypter = true)
    private String fddbrhfzrdh;


    /**
     * 法定代表人或负责人
     */
    @Desensitized(type = SensitiveTypeEnum.CHINESE_NAME)
    @Crypt(versions = "v1.0", separator = ",")
    private String fddbrhfzr;

    /**
     * 法定代表人或负责人证件号
     */
    @Desensitized(type = SensitiveTypeEnum.ID_CARD, isEncrypter = true)
    private String fddbrhfzrzjh;

    /**
     * 权利人邮编
     */
    private String qlryb;

    /**
     * 代理机构名称
     */
    private String dljgmc;

    /**
     * 数量
     */
    private String num;

    /**
     * 房屋套次
     */
    //@DictConversion(type = DataDictUtils.table_fwtc, rule = DataDictUtils.GETMCBYDM)
    private String fwtc;

    /**
     * 是否本地户籍（0:否，1：是）
     */
    //@DictConversion(type = DataDictUtils.table_hjlx, rule = DataDictUtils.GETMCBYDM)
    private String sfbdhj;

    /**
     * 婚姻状况
     */
    //@DictConversion(type = DataDictUtils.table_hyzt, rule = DataDictUtils.GETMCBYDM)
    private String hyzt;

    /**
     * 税号
     */
    private String sh;

    /**
     * 是否人脸认证
     */
    private String sfrz;

    /**
     * 是否人脸认证名称
     */
    private String sfrzmc;

    /**
     * 核验时间
     */
    private Date rzTime;

    /**
     * 权利人家庭成员
     */
    private List<QlrJtcy> qlrJtcies;

    /**
     * 是否会签认证
     */
    private Integer sfhqrz;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 共有方式
     */
    private String gyfs;

    private String gyfsMc;

    /**
     * 税款减免（0：否，1：是）
     */
    private String skjm;

    /**
     * 新增契税满两年 0 未满两年 1 满两年 放代码
     */
    private String qsmln;

    /**
     * 脱敏信息
     */
    private String qlrmcTm;
    private String qlrzjhTm;
    private String qlrtxdzTm;
    private String qlrlxdhTm;
    private String dlrdhTm;
    private String dlrmcTm;
    private String dlrzjhTm;
    private String fddbrhfzrTm;
    private String fddbrhfzrdhTm;
    private String fddbrhfzrzjhTm;

    /**
     * 房产证号(主要是为了适应分别持证情况 ）
     */
    private String fczh;

    /**
     * 是否存在家庭成员 0 ： 是 1： 否
     */
    private String sfczjtcy;

    /**
     * 是否完税（0 否 1 是 ）
     */
    private String sfws;

    /**
     * 代码转换名称
     */
    private String qlrsfzjzlMc;
    private String dlrsfzjzlMc;

    private String fwtcMc;

    private String sfbdhjMc;

    /**
     * 婚姻状况
     */
    private String hyztMc;

    /**
     * 法定代表人或负责人id
     */
    private String fddbrhfzrid;

    /**
     * 关系人种类代码	gxrzldm	字符串				1个人、2企业，放代码
     */
    private String gxrzldm;

    /**
     * 关系人种类名称	gxrzlmc	字符串				个人、企业，放名称
     */
    private String gxrzlmc;


    /**
     * 国籍（代码）
     */
    private String gjdm;

    /**
     * 国籍名称
     */
    private String gjmc;

    /**
     * 主产权人标志 （0:否，1：是:2:隐形共有人）
     */
    private String zcqrbz;

    /**
     * 法院流程--执行人
     */
    private List<GxYySqxxFyzxr> fyzxrList;

    /**
     * 法定代表人或负责人身份证件种类
     */
    private String fddbrhfzrsfzjzl;

    /**
     * 法定代表人或负责人身份证件种类名称
     */
    private String fddbrhfzrsfzjzlMc;

    /**
     * 权利人名称不脱敏
     */
    private String qlrmcNotTm;
    /**
     * 权利人证件号不脱敏
     */
    private String qlrzjhNotTm;

    /**
     * 是否直系亲属  (0：否， 1：是)
     */
    private String sfzxqs;

    /**
     * 修改人
     */
    private String updateUserGuid;

    /**
     * 修改时间
     */
    private Date updateDate;

    /**
     * 持证方式
     */
    private String czfs;

    /**
     * 持证方式名称
     */
    private String czfsmc;

    /**
     * 权利人、法人所属用户部门
     */
    private String subOrgId;

    /**
     * 是否需要核验 （0：是，1：否）
     */
    private String sfxyhy;

    /**
     * 分房婚姻状态 房改房
     */
    private String ffhyzt;

    private String ffhyztmc;

    /**
     * 顺序号，权利人排列顺序
     */
    private String sxh;

    /**
     * 是否需要人证比对（1：需要 2：不需要）
     */
    private String sfxyrzbd;

    /**
     * 组合贷时，标识公积金、银行等抵押顺序
     */
    private String dysx;

    /**
     * 是否缴税（0：是，1：否）
     */
    private String sfjs;

    /**
     * 家庭成员信息
     */
    private List<QlrJtcy> jtcyList;

    /**
     * 实际房屋套次
     */
    private String sjfwtc;
    /**
     * 实际房屋套次名称
     */
    private String sjfwtcmc;

    /**
     * 申报房屋套次
     */
    private String sbfwtc;
    /**
     * 申报房屋套次名称
     */
    private String sbfwtcmc;

    /**
     * 抵押权人类别(组合贷时标识抵押权人类别：1:公积金，2：银行）
     */
    private String dyqrlb;

    private String dlrdhNotTm;
    private String dlrmcNotTm;
    private String dlrzjhNotTm;

    /**
     * 是否具备购房资格，1是；0否
     */
    private String sfjbgfzg;

    /**
     * 是否签章（0:未签章，1:签章完成;2:签章失败 3:拒签）
     */
    private String sfqz;

    /**
     * 是否签章名称（0:否，1:是）
     */
    private String sfqzmc;

    /**
     * 签章时间
     */
    private Date qzTime;

    /**
     * 代理人是否签章（0:未签章，1:签章完成;2:签章失败 3:拒签）
     */
    private String dlrsfqz;

    /**
     * 监护人是否签章（0:未签章，1:签章完成;2:签章失败 3:拒签）
     */
    private String jhrsfqz;

    /**
     * 权利人部门Id
     */
    private String qlrorgid;

    /**
     * 权利人部门名称
     */
    private String qlrorgmc;

    /**
     * 父组织ID
     */
    private String parentOrgId;
    private String parentOrgIdName;

    /**
     * 权利人和角色关系表
     */
    private List<GxYySqxxQlrRole> qlrRole;

    /**
     * 是否开票
     */
    private String sfkp;

    /**
     * 是否小微企业
     */
    private String sfxwqy;

    /**
     * 权利人电子邮箱
     */
    private String qlrEmail;

    /**
     * 代理人种类
     */
    private String dlrzl;

    /**
     * 监护人信息
     */
    private List<QlrJhr> jhrList;

    /**
     * 是否月结（1:是，0：否）
     */
    private String sfyj;

    private String sfyjmc;

    /**
     * 是否打印纸质证书（1:是，0：否）
     */
    private String sfdyzzzs;

    /**
     * 完税证明获取方式（ 0：上传税票；1：输入契税完税凭证的电子税票号核税；）
     */
    private String wszmhqfs;

    /**
     * 税款减免原因
     */
    private String skjmyy;

    /**
     * 税款减免登记费，1是（减免）0否
     */
    private String skjmdjf;

    /**
     * 申请书内容
     */
    private String sqsnr;

    private Map sqsnrMap;
    /**
     * 区域代码 sqxx表qydm
     */
    private String qydm;

    /**
     * 标记是否为合同中的数据（1:是，0:否）
     */
    private String sfht;

    /**
     * 购买方直系亲属标志(gx_yy_zd_type.GMFZXQSBZ)
     */
    private String gmfzxqsbz;
    private String gmfzxqsbzmc;

    /**
     * 代理人ID
     */
    private String dlrid;

    /**
     * 签署url地址 第三方返回
     */
    private String qsurl;

    /**
     * 委托事项
     */
    private String wtsx;

    /**
     * 邮寄地址
     */
    private String yjdz;

    /**
     * 权利人特征
     */
    private String qlrtz;
    /**
     * 税务约定份额
     */
    private String swydfe;
    /**
     * 购买住房限购协查申请（买方1：是；0：否）
     */
    private String sfxcsq;

    /**
     * 核验材料编码（人才编码）
     */
    private String hyclbh;

    /**
     * 是否购买两年 1 ： 是 0： 否
     */
    private String sfgmln;

    /**
     * 现有住房坐落（多个,隔开）
     */
    private String xyzfzl;
    /**
     * 企业经办人id(用于电子签名)
     */
    private String qyjbrid;

    /**
     * 企业经办人姓名
     */
    private String qyjbr;

    /**
     * 是否领证人（1：是，0：否）
     */
    private String sflzr;

    /**
     * 是否代理人领证人（1：是，0：否）
     */
    private String sfdlrlzr;
    /**
     * (非qlr表字段)是否意愿认证（0:无需认证，1:是 认证通过，2：否 未认证）
     */
    private String sfyyrz;

    /**
     * 云签方式（0；单独云签，1：批量云签）
     */
    private String yqfs;

    /**
     * 是否主贷款人 1是 0否
     */
    private String sfzdr;

    /**
     * 与主贷款人身份关系（字典项）
     */
    private String yzdrsfgx;
    private String yzdrsfgxmc;

    /**
     * 是否购房提取公积金 1是 0否
     */
    private String sfgftq;

    /**
     * 拟提取公积金金额
     */
    private Double ntqje;

    /**
     * 权利人代办信息
     */
    private List<QlrDbrxx> qlrdbrList;

    /**
     * 申请类型代码
     * 申请登记类型代码
     */
    private String sqlxdm;
    private String sqdjlxdm;

    /**
     * 权利人关系人
     */
    private List<QlrGxr> qlrgxrList;

    /**
     * 是否持证人（0：否，1：是）
     */
    private String sfczr;

    /**
     * 户籍
     */
    private String hj;

    /**
     * 交易者性质
     */
    private String jyzxz;

    /**
     * 交易双方是否三代以内直系血亲（0 否 1 是 ）
     */
    private String jysfsfsdynzxxq;

    /**
     * 是否为隐性共有人（1:是，0:否）
     */
    private String sfyxgyr;

    /**
     * 申报房屋套次备注（修改申报房屋套次时受理人员填写的备注）
     */
    private String sbfwtcbz;

    /**
     * 代理起始日期
     */
    private String dlqsrq;

    /**
     * 代理结束日期
     */
    private String dljsrq;
    /**
     * '权利人性别(1：男，2：女，3：未知)';
     */
    private String qlrxb;
    private String qlrxbMc;
    /**
     * 短信告知联系电话
     */
    @Desensitized(type = SensitiveTypeEnum.MOBILE_PHONE, isEncrypter = true)
    private String dxgzlxdh;
    /**
     * 短信告知联系电话脱敏
     */
    private String dxgzlxdhTm;

    /**
     * 户籍所在省（zd_type表对照）
     */
    private String hjszs;
    /**
     * 户籍所在地市（zd_type表对照）
     */
    private String hjszds;
    /**
     * 户籍所在地县（zd_type表对照）
     */
    private String hjszdx;
    /**
     * 如果是否云签选择“是”，判断当事人是否云签。云签状态默认显示“未云签”，云签完，云签状态显示“已云签”；如果是否云签选择“否”，云签状态显示“已选择无需云签”
     */
    private String yqzt;
    /**
     * 权利人类别代码（1预购人、2买受人、3出卖人、4债务人、5借款人）
     */
    private String qlrlb;
    /**
     * 权利人类别代码（1预购人、2买受人、3出卖人、4债务人、5借款人）
     */
    private String qlrlbMc;
    public String getQlrlxmc() {
        return qlrlxmc;
    }

    public void setQlrlxmc(String qlrlxmc) {
        this.qlrlxmc = qlrlxmc;
    }

    public String getQlrxbMc() {
        return qlrxbMc;
    }

    public void setQlrxbMc(String qlrxbMc) {
        this.qlrxbMc = qlrxbMc;
    }

    public String getQlrxb() {
        return qlrxb;
    }

    public void setQlrxb(String qlrxb) {
        this.qlrxb = qlrxb;
    }

    public String getJysfsfsdynzxxq() {
        return jysfsfsdynzxxq;
    }

    public void setJysfsfsdynzxxq(String jysfsfsdynzxxq) {
        this.jysfsfsdynzxxq = jysfsfsdynzxxq;
    }

    public String getSfczr() {
        return sfczr;
    }

    public void setSfczr(String sfczr) {
        this.sfczr = sfczr;
    }

    public List<QlrGxr> getQlrgxrList() {
        return qlrgxrList;
    }

    public void setQlrgxrList(List<QlrGxr> qlrgxrList) {
        this.qlrgxrList = qlrgxrList;
    }

    public String getSqlxdm() {
        return sqlxdm;
    }

    public void setSqlxdm(String sqlxdm) {
        this.sqlxdm = sqlxdm;
    }

    public String getSqdjlxdm() {
        return sqdjlxdm;
    }

    public void setSqdjlxdm(String sqdjlxdm) {
        this.sqdjlxdm = sqdjlxdm;
    }

    public String getSfyyrz() {
        return sfyyrz;
    }

    public void setSfyyrz(String sfyyrz) {
        this.sfyyrz = sfyyrz;
    }

    public String getWtsx() {
        return wtsx;
    }

    public void setWtsx(String wtsx) {
        this.wtsx = wtsx;
    }

    public String getSbfwtc() {
        return sbfwtc;
    }

    public void setSbfwtc(String sbfwtc) {
        this.sbfwtc = sbfwtc;
    }

    public String getJhrsfqz() {
        return jhrsfqz;
    }

    public void setJhrsfqz(String jhrsfqz) {
        this.jhrsfqz = jhrsfqz;
    }

    public String getQsurl() {
        return qsurl;
    }

    public void setQsurl(String qsurl) {
        this.qsurl = qsurl;
    }

    public String getDlrsfqz() {
        return dlrsfqz;
    }

    public void setDlrsfqz(String dlrsfqz) {
        this.dlrsfqz = dlrsfqz;
    }

    public String getDlrid() {
        return dlrid;
    }

    public void setDlrid(String dlrid) {
        this.dlrid = dlrid;
    }

    public String getGmfzxqsbz() {
        return gmfzxqsbz;
    }

    public void setGmfzxqsbz(String gmfzxqsbz) {
        this.gmfzxqsbz = gmfzxqsbz;
    }

    public String getGmfzxqsbzmc() {
        return gmfzxqsbzmc;
    }

    public void setGmfzxqsbzmc(String gmfzxqsbzmc) {
        this.gmfzxqsbzmc = gmfzxqsbzmc;
    }

    public String getSfht() {
        return sfht;
    }

    public void setSfht(String sfht) {
        this.sfht = sfht;
    }

    public String getQydm() {
        return qydm;
    }

    public void setQydm(String qydm) {
        this.qydm = qydm;
    }

    public Map getSqsnrMap() {
        return sqsnrMap;
    }

    public void setSqsnrMap(Map sqsnrMap) {
        this.sqsnrMap = sqsnrMap;
    }

    public String getSqsnr() {
        return sqsnr;
    }

    public void setSqsnr(String sqsnr) {
        this.sqsnr = sqsnr;
    }

    public String getSkjmdjf() {
        return skjmdjf;
    }

    public void setSkjmdjf(String skjmdjf) {
        this.skjmdjf = skjmdjf;
    }

    public String getSkjmyy() {
        return skjmyy;
    }

    public void setSkjmyy(String skjmyy) {
        this.skjmyy = skjmyy;
    }

    public String getSfyj() {
        return sfyj;
    }

    public void setSfyj(String sfyj) {
        this.sfyj = sfyj;
    }

    public String getSfyjmc() {
        return sfyjmc;
    }

    public void setSfyjmc(String sfyjmc) {
        this.sfyjmc = sfyjmc;
    }

    public List<QlrJhr> getJhrList() {
        return jhrList;
    }

    public void setJhrList(List<QlrJhr> jhrList) {
        this.jhrList = jhrList;
    }

    public String getDlrzl() {
        return dlrzl;
    }

    public void setDlrzl(String dlrzl) {
        this.dlrzl = dlrzl;
    }

    public String getQlrEmail() {
        return qlrEmail;
    }

    public void setQlrEmail(String qlrEmail) {
        this.qlrEmail = qlrEmail;
    }

    public String getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(String parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgIdName() {
        return parentOrgIdName;
    }

    public void setParentOrgIdName(String parentOrgIdName) {
        this.parentOrgIdName = parentOrgIdName;
    }

    public List<GxYySqxxQlrRole> getQlrRole() {
        return qlrRole;
    }

    public void setQlrRole(List<GxYySqxxQlrRole> qlrRole) {
        this.qlrRole = qlrRole;
    }

    public String getSfqzmc() {
        return sfqzmc;
    }

    public void setSfqzmc(String sfqzmc) {
        this.sfqzmc = sfqzmc;
    }

    public String getSfqz() {
        return sfqz;
    }

    public void setSfqz(String sfqz) {
        this.sfqz = sfqz;
    }

    public Date getQzTime() {
        return qzTime;
    }

    public void setQzTime(Date qzTime) {
        this.qzTime = qzTime;
    }

    public String getDlrdhNotTm() {
        return dlrdhNotTm;
    }

    public void setDlrdhNotTm(String dlrdhNotTm) {
        this.dlrdhNotTm = dlrdhNotTm;
    }

    public String getDlrmcNotTm() {
        return dlrmcNotTm;
    }

    public void setDlrmcNotTm(String dlrmcNotTm) {
        this.dlrmcNotTm = dlrmcNotTm;
    }

    public String getDlrzjhNotTm() {
        return dlrzjhNotTm;
    }

    public void setDlrzjhNotTm(String dlrzjhNotTm) {
        this.dlrzjhNotTm = dlrzjhNotTm;
    }

    public String getDyqrlb() {
        return dyqrlb;
    }

    public void setDyqrlb(String dyqrlb) {
        this.dyqrlb = dyqrlb;
    }

    public String getSjfwtc() {
        return sjfwtc;
    }

    public void setSjfwtc(String sjfwtc) {
        this.sjfwtc = sjfwtc;
    }

    public List<QlrJtcy> getJtcyList() {
        return jtcyList;
    }

    public void setJtcyList(List<QlrJtcy> jtcyList) {
        this.jtcyList = jtcyList;
    }

    public String getSfjs() {
        return sfjs;
    }

    public void setSfjs(String sfjs) {
        this.sfjs = sfjs;
    }

    public String getSfxyrzbd() {
        return sfxyrzbd;
    }

    public void setSfxyrzbd(String sfxyrzbd) {
        this.sfxyrzbd = sfxyrzbd;
    }

    public String getCzfsmc() {
        return czfsmc;
    }

    public void setCzfsmc(String czfsmc) {
        this.czfsmc = czfsmc;
    }

    public String getCzfs() {
        return czfs;
    }

    public void setCzfs(String czfs) {
        this.czfs = czfs;
    }

    public String getUpdateUserGuid() {
        return updateUserGuid;
    }

    public void setUpdateUserGuid(String updateUserGuid) {
        this.updateUserGuid = updateUserGuid;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getSfzxqs() {
        return sfzxqs;
    }

    public void setSfzxqs(String sfzxqs) {
        this.sfzxqs = sfzxqs;
    }

    public String getQlrzjhNotTm() {
        return qlrzjhNotTm;
    }

    public void setQlrzjhNotTm(String qlrzjhNotTm) {
        this.qlrzjhNotTm = qlrzjhNotTm;
    }

    public String getGjdm() {
        return gjdm;
    }

    public void setGjdm(String gjdm) {
        this.gjdm = gjdm;
    }

    public String getGjmc() {
        return gjmc;
    }

    public void setGjmc(String gjmc) {
        this.gjmc = gjmc;
    }

    public String getZcqrbz() {
        return zcqrbz;
    }

    public void setZcqrbz(String zcqrbz) {
        this.zcqrbz = zcqrbz;
    }

    public String getGxrzldm() {
        return gxrzldm;
    }

    public void setGxrzldm(String gxrzldm) {
        this.gxrzldm = gxrzldm;
    }

    public String getGxrzlmc() {
        return gxrzlmc;
    }

    public void setGxrzlmc(String gxrzlmc) {
        this.gxrzlmc = gxrzlmc;
    }

    public String getFddbrhfzrid() {
        return fddbrhfzrid;
    }

    public void setFddbrhfzrid(String fddbrhfzrid) {
        this.fddbrhfzrid = fddbrhfzrid;
    }

    public String getQlrid() {
        return qlrid;
    }

    public void setQlrid(String qlrid) {
        this.qlrid = qlrid;
    }

    public String getSqid() {
        return sqid;
    }

    public void setSqid(String sqid) {
        this.sqid = sqid;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrsfzjzl() {
        return qlrsfzjzl;
    }

    public void setQlrsfzjzl(String qlrsfzjzl) {
        this.qlrsfzjzl = qlrsfzjzl;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getQlrtxdz() {
        return qlrtxdz;
    }

    public void setQlrtxdz(String qlrtxdz) {
        this.qlrtxdz = qlrtxdz;
    }

    public String getQlrlx() {
        return qlrlx;
    }

    public void setQlrlx(String qlrlx) {
        this.qlrlx = qlrlx;
    }

    public String getQlbl() {
        return qlbl;
    }

    public void setQlbl(String qlbl) {
        this.qlbl = qlbl;
    }

    public String getQlrlxdh() {
        return qlrlxdh;
    }

    public void setQlrlxdh(String qlrlxdh) {
        this.qlrlxdh = qlrlxdh;
    }

    public String getZdjlx() {
        return zdjlx;
    }

    public void setZdjlx(String zdjlx) {
        this.zdjlx = zdjlx;
    }

    public String getZdjlxmc() {
        return zdjlxmc;
    }

    public void setZdjlxmc(String zdjlxmc) {
        this.zdjlxmc = zdjlxmc;
    }

    public String getZjlx() {
        return zjlx;
    }

    public void setZjlx(String zjlx) {
        this.zjlx = zjlx;
    }

    public String getDlrdh() {
        return dlrdh;
    }

    public void setDlrdh(String dlrdh) {
        this.dlrdh = dlrdh;
    }

    public String getDlrmc() {
        return dlrmc;
    }

    public void setDlrmc(String dlrmc) {
        this.dlrmc = dlrmc;
    }

    public String getDlrsfzjzl() {
        return dlrsfzjzl;
    }

    public void setDlrsfzjzl(String dlrsfzjzl) {
        this.dlrsfzjzl = dlrsfzjzl;
    }

    public String getFddbrhfzrdh() {
        return fddbrhfzrdh;
    }

    public void setFddbrhfzrdh(String fddbrhfzrdh) {
        this.fddbrhfzrdh = fddbrhfzrdh;
    }

    public String getFddbrhfzr() {
        return fddbrhfzr;
    }

    public void setFddbrhfzr(String fddbrhfzr) {
        this.fddbrhfzr = fddbrhfzr;
    }

    public String getQlryb() {
        return qlryb;
    }

    public void setQlryb(String qlryb) {
        this.qlryb = qlryb;
    }

    public String getDljgmc() {
        return dljgmc;
    }

    public void setDljgmc(String dljgmc) {
        this.dljgmc = dljgmc;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getFddbrhfzrzjh() {
        return fddbrhfzrzjh;
    }

    public void setFddbrhfzrzjh(String fddbrhfzrzjh) {
        this.fddbrhfzrzjh = fddbrhfzrzjh;
    }

    public String getDlrzjh() {
        return dlrzjh;
    }

    public void setDlrzjh(String dlrzjh) {
        this.dlrzjh = dlrzjh;
    }

    public String getFwtc() {
        return fwtc;
    }

    public void setFwtc(String fwtc) {
        this.fwtc = fwtc;
    }

    public String getSfbdhj() {
        return sfbdhj;
    }

    public void setSfbdhj(String sfbdhj) {
        this.sfbdhj = sfbdhj;
    }

    public String getHyzt() {
        return hyzt;
    }

    public void setHyzt(String hyzt) {
        this.hyzt = hyzt;
    }

    public String getSfws() {
        return sfws;
    }

    public void setSfws(String sfws) {
        this.sfws = sfws;
    }

    public String getSh() {
        return sh;
    }

    public void setSh(String sh) {
        this.sh = sh;
    }

    public String getSfrz() {
        return sfrz;
    }

    public void setSfrz(String sfrz) {
        this.sfrz = sfrz;
    }

    public String getSfrzmc() {
        return sfrzmc;
    }

    public void setSfrzmc(String sfrzmc) {
        this.sfrzmc = sfrzmc;
    }

    public Date getRzTime() {
        return rzTime;
    }

    public void setRzTime(Date rzTime) {
        this.rzTime = rzTime;
    }

    public List<QlrJtcy> getQlrJtcies() {
        return qlrJtcies;
    }

    public void setQlrJtcies(List<QlrJtcy> qlrJtcies) {
        this.qlrJtcies = qlrJtcies;
    }

    public Integer getSfhqrz() {
        return sfhqrz;
    }

    public void setSfhqrz(Integer sfhqrz) {
        this.sfhqrz = sfhqrz;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getGyfs() {
        return gyfs;
    }

    public void setGyfs(String gyfs) {
        this.gyfs = gyfs;
    }

    public String getGyfsMc() {
        return gyfsMc;
    }

    public void setGyfsMc(String gyfsMc) {
        this.gyfsMc = gyfsMc;
    }

    public String getQlrmcTm() {
        return qlrmcTm;
    }

    public void setQlrmcTm(String qlrmcTm) {
        this.qlrmcTm = qlrmcTm;
    }

    public String getQlrzjhTm() {
        return qlrzjhTm;
    }

    public void setQlrzjhTm(String qlrzjhTm) {
        this.qlrzjhTm = qlrzjhTm;
    }

    public String getQlrtxdzTm() {
        return qlrtxdzTm;
    }

    public void setQlrtxdzTm(String qlrtxdzTm) {
        this.qlrtxdzTm = qlrtxdzTm;
    }

    public String getQlrlxdhTm() {
        return qlrlxdhTm;
    }

    public void setQlrlxdhTm(String qlrlxdhTm) {
        this.qlrlxdhTm = qlrlxdhTm;
    }

    public String getDlrdhTm() {
        return dlrdhTm;
    }

    public void setDlrdhTm(String dlrdhTm) {
        this.dlrdhTm = dlrdhTm;
    }

    public String getDlrmcTm() {
        return dlrmcTm;
    }

    public void setDlrmcTm(String dlrmcTm) {
        this.dlrmcTm = dlrmcTm;
    }

    public String getDlrzjhTm() {
        return dlrzjhTm;
    }

    public void setDlrzjhTm(String dlrzjhTm) {
        this.dlrzjhTm = dlrzjhTm;
    }

    public String getFddbrhfzrTm() {
        return fddbrhfzrTm;
    }

    public void setFddbrhfzrTm(String fddbrhfzrTm) {
        this.fddbrhfzrTm = fddbrhfzrTm;
    }

    public String getFddbrhfzrdhTm() {
        return fddbrhfzrdhTm;
    }

    public void setFddbrhfzrdhTm(String fddbrhfzrdhTm) {
        this.fddbrhfzrdhTm = fddbrhfzrdhTm;
    }

    public String getFddbrhfzrzjhTm() {
        return fddbrhfzrzjhTm;
    }

    public void setFddbrhfzrzjhTm(String fddbrhfzrzjhTm) {
        this.fddbrhfzrzjhTm = fddbrhfzrzjhTm;
    }

    public String getSkjm() {
        return skjm;
    }

    public void setSkjm(String skjm) {
        this.skjm = skjm;
    }

    public String getQsmln() {
        return qsmln;
    }

    public void setQsmln(String qsmln) {
        this.qsmln = qsmln;
    }

    public String getFczh() {
        return fczh;
    }

    public void setFczh(String fczh) {
        this.fczh = fczh;
    }

    public String getSubOrgId() {
        return subOrgId;
    }

    public void setSubOrgId(String subOrgId) {
        this.subOrgId = subOrgId;
    }

    public String getSfczjtcy() {
        return sfczjtcy;
    }

    public void setSfczjtcy(String sfczjtcy) {
        this.sfczjtcy = sfczjtcy;
    }

    public String getQlrsfzjzlMc() {
        return qlrsfzjzlMc;
    }

    public void setQlrsfzjzlMc(String qlrsfzjzlMc) {
        this.qlrsfzjzlMc = qlrsfzjzlMc;
    }

    public String getDlrsfzjzlMc() {
        return dlrsfzjzlMc;
    }

    public void setDlrsfzjzlMc(String dlrsfzjzlMc) {
        this.dlrsfzjzlMc = dlrsfzjzlMc;
    }

    public String getFwtcMc() {
        return fwtcMc;
    }

    public void setFwtcMc(String fwtcMc) {
        this.fwtcMc = fwtcMc;
    }

    public String getSfbdhjMc() {
        return sfbdhjMc;
    }

    public void setSfbdhjMc(String sfbdhjMc) {
        this.sfbdhjMc = sfbdhjMc;
    }

    public String getHyztMc() {
        return hyztMc;
    }

    public void setHyztMc(String hyztMc) {
        this.hyztMc = hyztMc;
    }

    public List<GxYySqxxFyzxr> getFyzxrList() {
        return fyzxrList;
    }

    public void setFyzxrList(List<GxYySqxxFyzxr> fyzxrList) {
        this.fyzxrList = fyzxrList;
    }

    public String getFddbrhfzrsfzjzl() {
        return fddbrhfzrsfzjzl;
    }

    public void setFddbrhfzrsfzjzl(String fddbrhfzrsfzjzl) {
        this.fddbrhfzrsfzjzl = fddbrhfzrsfzjzl;
    }

    public String getFddbrhfzrsfzjzlMc() {
        return fddbrhfzrsfzjzlMc;
    }

    public void setFddbrhfzrsfzjzlMc(String fddbrhfzrsfzjzlMc) {
        this.fddbrhfzrsfzjzlMc = fddbrhfzrsfzjzlMc;
    }

    public String getSfxyhy() {
        return sfxyhy;
    }

    public void setSfxyhy(String sfxyhy) {
        this.sfxyhy = sfxyhy;
    }

    public String getSxh() {
        return sxh;
    }

    public void setSxh(String sxh) {
        this.sxh = sxh;
    }

    public String getFfhyzt() {
        return ffhyzt;
    }

    public void setFfhyzt(String ffhyzt) {
        this.ffhyzt = ffhyzt;
    }

    public String getFfhyztmc() {
        return ffhyztmc;
    }

    public void setFfhyztmc(String ffhyztmc) {
        this.ffhyztmc = ffhyztmc;
    }

    public String getDysx() {
        return dysx;
    }

    public void setDysx(String dysx) {
        this.dysx = dysx;
    }

    public String getSfjbgfzg() {
        return sfjbgfzg;
    }

    public void setSfjbgfzg(String sfjbgfzg) {
        this.sfjbgfzg = sfjbgfzg;
    }

    public String getQlrorgid() {
        return qlrorgid;
    }

    public void setQlrorgid(String qlrorgid) {
        this.qlrorgid = qlrorgid;
    }

    public String getQlrorgmc() {
        return qlrorgmc;
    }

    public void setQlrorgmc(String qlrorgmc) {
        this.qlrorgmc = qlrorgmc;
    }

    public String getSfkp() {
        return sfkp;
    }

    public void setSfkp(String sfkp) {
        this.sfkp = sfkp;
    }

    public String getSfxwqy() {
        return sfxwqy;
    }

    public void setSfxwqy(String sfxwqy) {
        this.sfxwqy = sfxwqy;
    }

    public String getSfdyzzzs() {
        return sfdyzzzs;
    }

    public void setSfdyzzzs(String sfdyzzzs) {
        this.sfdyzzzs = sfdyzzzs;
    }

    public String getWszmhqfs() {
        return wszmhqfs;
    }

    public void setWszmhqfs(String wszmhqfs) {
        this.wszmhqfs = wszmhqfs;
    }

    public String getYjdz() {
        return yjdz;
    }

    public void setYjdz(String yjdz) {
        this.yjdz = yjdz;
    }

    public String getSjfwtcmc() {
        return sjfwtcmc;
    }

    public void setSjfwtcmc(String sjfwtcmc) {
        this.sjfwtcmc = sjfwtcmc;
    }

    public String getSbfwtcmc() {
        return sbfwtcmc;
    }

    public void setSbfwtcmc(String sbfwtcmc) {
        this.sbfwtcmc = sbfwtcmc;
    }

    public String getQlrmcNotTm() {
        return qlrmcNotTm;
    }

    public void setQlrmcNotTm(String qlrmcNotTm) {
        this.qlrmcNotTm = qlrmcNotTm;
    }

    public String getQlrtz() {
        return qlrtz;
    }

    public void setQlrtz(String qlrtz) {
        this.qlrtz = qlrtz;
    }

    public String getSwydfe() {
        return swydfe;
    }

    public void setSwydfe(String swydfe) {
        this.swydfe = swydfe;
    }

    public String getSfxcsq() {
        return sfxcsq;
    }

    public void setSfxcsq(String sfxcsq) {
        this.sfxcsq = sfxcsq;
    }

    public String getHyclbh() {
        return hyclbh;
    }

    public void setHyclbh(String hyclbh) {
        this.hyclbh = hyclbh;
    }

    public String getSfgmln() {
        return sfgmln;
    }

    public void setSfgmln(String sfgmln) {
        this.sfgmln = sfgmln;
    }

    public String getXyzfzl() {
        return xyzfzl;
    }

    public void setXyzfzl(String xyzfzl) {
        this.xyzfzl = xyzfzl;
    }

    public String getQyjbrid() {
        return qyjbrid;
    }

    public void setQyjbrid(String qyjbrid) {
        this.qyjbrid = qyjbrid;
    }

    public String getQyjbr() {
        return qyjbr;
    }

    public void setQyjbr(String qyjbr) {
        this.qyjbr = qyjbr;
    }

    public String getSflzr() {
        return sflzr;
    }

    public void setSflzr(String sflzr) {
        this.sflzr = sflzr;
    }

    public String getSfdlrlzr() {
        return sfdlrlzr;
    }

    public void setSfdlrlzr(String sfdlrlzr) {
        this.sfdlrlzr = sfdlrlzr;
    }

    public String getYqfs() {
        return yqfs;
    }

    public void setYqfs(String yqfs) {
        this.yqfs = yqfs;
    }

    public String getSfzdr() {
        return sfzdr;
    }

    public void setSfzdr(String sfzdr) {
        this.sfzdr = sfzdr;
    }

    public String getYzdrsfgx() {
        return yzdrsfgx;
    }

    public void setYzdrsfgx(String yzdrsfgx) {
        this.yzdrsfgx = yzdrsfgx;
    }

    public String getYzdrsfgxmc() {
        return yzdrsfgxmc;
    }

    public void setYzdrsfgxmc(String yzdrsfgxmc) {
        this.yzdrsfgxmc = yzdrsfgxmc;
    }

    public String getSfgftq() {
        return sfgftq;
    }

    public void setSfgftq(String sfgftq) {
        this.sfgftq = sfgftq;
    }

    public Double getNtqje() {
        return ntqje;
    }

    public void setNtqje(Double ntqje) {
        this.ntqje = ntqje;
    }

    public List<QlrDbrxx> getQlrdbrList() {
        return qlrdbrList;
    }

    public void setQlrdbrList(List<QlrDbrxx> qlrdbrList) {
        this.qlrdbrList = qlrdbrList;
    }

    public String getHj() {
        return hj;
    }

    public void setHj(String hj) {
        this.hj = hj;
    }

    public String getJyzxz() {
        return jyzxz;
    }

    public void setJyzxz(String jyzxz) {
        this.jyzxz = jyzxz;
    }

    public String getSfyxgyr() {
        return sfyxgyr;
    }

    public void setSfyxgyr(String sfyxgyr) {
        this.sfyxgyr = sfyxgyr;
    }

    public String getSbfwtcbz() {
        return sbfwtcbz;
    }

    public void setSbfwtcbz(String sbfwtcbz) {
        this.sbfwtcbz = sbfwtcbz;
    }

    public String getDlqsrq() {
        return dlqsrq;
    }

    public void setDlqsrq(String dlqsrq) {
        this.dlqsrq = dlqsrq;
    }

    public String getDljsrq() {
        return dljsrq;
    }

    public void setDljsrq(String dljsrq) {
        this.dljsrq = dljsrq;
    }

    public String getDxgzlxdh() {
        return dxgzlxdh;
    }

    public void setDxgzlxdh(String dxgzlxdh) {
        this.dxgzlxdh = dxgzlxdh;
    }

    public String getDxgzlxdhTm() {
        return dxgzlxdhTm;
    }

    public void setDxgzlxdhTm(String dxgzlxdhTm) {
        this.dxgzlxdhTm = dxgzlxdhTm;
    }

    public String getHjszs() {
        return hjszs;
    }

    public void setHjszs(String hjszs) {
        this.hjszs = hjszs;
    }

    public String getHjszds() {
        return hjszds;
    }

    public void setHjszds(String hjszds) {
        this.hjszds = hjszds;
    }

    public String getHjszdx() {
        return hjszdx;
    }

    public void setHjszdx(String hjszdx) {
        this.hjszdx = hjszdx;
    }

    public String getYqzt() {
        return yqzt;
    }

    public void setYqzt(String yqzt) {
        this.yqzt = yqzt;
    }

    public String getQlrlb() {
        return qlrlb;
    }

    public void setQlrlb(String qlrlb) {
        this.qlrlb = qlrlb;
    }

    public String getQlrlbMc() {
        return qlrlbMc;
    }

    public void setQlrlbMc(String qlrlbMc) {
        this.qlrlbMc = qlrlbMc;
    }
}