package cn.gtmap.hlw.core.dto.third.dzzz;

import lombok.Data;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2025/9/10
 * @description 电子营业执照回调接口
 */
@Data
public class DzzzYyzzNoticeQueryContentDTO {

    /**
     * 标识类型
     */
    private String qrtype;
    /**
     * 业务请求唯一标识
     */
    private String qrid;
    /**
     * 统一社会信用代码
     */
    private String uniscid;
    /**
     * 企业名称
     */
    private String entname;
    /**
     * 电子营业执照序列号
     */
    private String licencesn;
    /**
     * 处理结果: 0-已处理，非0-等待处理
     */
    private String operflag;
    /**
     * 法定代表人
     */
    private String name;
    /**
     * 照面上的类型
     */
    private String enttype_cn;
    /**
     * 企业类型, 1-企业，8-个体户
     */
    private String type;
    /**
     * 登记机关
     */
    private String regorg_cn;
    /**
     * 登记日期, 格式: yyyyMMdd
     */
    private String apprdate;
    /**
     * 注册资本, 格式: 整万元（5000万）；非整万元（931.6185万）
     */
    private String regcap;
    /**
     * 注册资本币种, 例如: 人民币
     */
    private String regCapCur;
    /**
     * 住所
     */
    private String dom;
    /**
     * 成立日期, 格式: yyyyMMdd
     */
    private String estdate;
    /**
     * 经营(驻在)期限自, 格式: yyyyMMdd
     */
    private String opfrom;
    /**
     * 经营(驻在)期限至, 格式: yyyyMMdd，永久的是99991231
     */
    private String opto;
    /**
     * 经营范围/业务范围
     */
    private String opscope;
    /**
     * 电子营业执照实体
     */
    private String licenceentity;
    /**
     * 企业状态, 1：存续，2：吊销，6：迁出
     */
    private String state;
    /**
     * 持照人姓名
     */
    private String oper;
    /**
     * 持照人身份类型, 0-法人，1-证照管理员，2-办事人
     */
    private String opertype;
    /**
     * 电子营业执照文件URL
     */
    private String imageurl;
    /**
     * 办事人执照唯一标识
     */
    private String auth_uniqueid;
    /**
     * 办事人授权事项内容
     */
    private String auth_content;
    /**
     * 办事人授权事项编码
     */
    private String auth_content_code;
    /**
     * 办事人授权事项开始日期, 格式yyyyMMdd
     */
    private String auth_startdate;
    /**
     * 办事人授权事项截止日期, 格式yyyyMMdd
     */
    private String auth_term;
    /**
     * 请求时间, 格式: 20180909152100
     */
    private String opertime;

}
