package cn.gtmap.hlw.core.dao.equip;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.equip.EquipDetailQueryDTO;
import cn.gtmap.hlw.core.dto.equip.EquipDetailResultDTO;
import cn.gtmap.hlw.core.model.GxYyUserEquipRel;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/3/13 15:32
 * @description 设备关系
 */
public interface GxYyUserEquipRelDao  {

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return:PageInfo<EquipDetailResultDTO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    PageInfo<EquipDetailResultDTO> page(EquipDetailQueryDTO paramsDTO);

    /**
     * 保存
     *
     * @param gxYyUserEquipRel
     * @return:PageInfo<EquipDetailResultDTO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
     void saveOrUpdate(GxYyUserEquipRel gxYyUserEquipRel);

    /**
     * 保存
     *
     * @param gxYyUserEquipRelList
     * @return:PageInfo<EquipDetailResultDTO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdateBatch(List<GxYyUserEquipRel> gxYyUserEquipRelList);


    /**
     * 查询
     *
     * @param equipId 设备id
     * @return:PageInfo<EquipDetailResultDTO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyUserEquipRel> queryByEquipId(String equipId);

    /**
     * 查询
     *
     * @param equipIdList 设备id集合
     * @return:PageInfo<EquipDetailResultDTO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyUserEquipRel> queryByEquipIdList(List<String> equipIdList);

    /**
     * 通过用户id集合，设备id 删除设备与用户关系
     *
     * @param equipId      设备id
     * @param userGuidList 用户集合
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void deleteByEquipIdAndUserGuidList(String equipId, List<String> userGuidList);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据用户id查询用户设备关系
     */
    GxYyUserEquipRel queryByUserGuid(String userGuid);

    /**
     * @param
     * @return
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 根据用户id删除用户设备关系
     */
    void deleteByUserId(String userGuid);
}
