package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxLdxx;

import java.util.List;

/**
 * 在线申请--林地信息(GxYySqxxLdxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:24:35
 */
public interface GxYySqxxLdxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param ldxxid 主键
     * @return 实例对象
     */
    GxYySqxxLdxx get(Integer ldxxid);

    /**
     * 通过slbh查询数据集合
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYySqxxLdxx> list(String slbh);

    /**
     * 通过slbhList查询数据集合
     *
     * @param slbhList 受理编号
     * @return 实例对象
     */
    List<GxYySqxxLdxx> list(List<String> slbhList);

    /**
     * 新增数据
     *
     * @param gxYySqxxLdxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxLdxx gxYySqxxLdxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxLdxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxLdxx gxYySqxxLdxx);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxLdxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxLdxx gxYySqxxLdxx);

    /**
     * 通过slbhList删除数据
     *
     * @param slbhList 实例对象
     * @return 影响行数
     */
    int deleteBySlbhList(List<String> slbhList);
}

