package cn.gtmap.hlw.core.enums.jdxx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/27
 * @description 合同上报
 */
@Getter
@AllArgsConstructor
public enum HtsbEnum {
    /**
     * 待生成
     */
    DSB("0", "待上报"),
    /**
     * 生成成功
     */
    SBCG("1", "上报成功"),
    /**
     * 生成失败
     */
    SBSB("2", "上报失败");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (HtsbEnum xq : HtsbEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
