package cn.gtmap.hlw.core.dto.sw.hs;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/18
 * @description 交易方信息
 */
@Data
public class SwHsJyfxxDTO {
    /**
     * 交易方 UUID
     */
    private String jyfuuid;
    /**
     * 转让方承受方标志
     */
    private String zrfcsfbz;
    /**
     * 纳税人识别号码
     */
    private String nsrsbh;
    /**
     * 纳税人名称
     */
    private String nsrmc;
    /**
     * 地址
     */
    private String dz;
    /**
     * 行业代码
     */
    private String hydm;
    /**
     * 登记注册类型代码
     */
    private String djzclxdm;
    /**
     * 增值税一般纳税人标志
     */
    private String zzsybnsr;
    /**
     * 单位隶属关系代码
     */
    private String dwlsgxdm;
    /**
     * 主产权人标志
     */
    private String zqrbz;
    /**
     * 身份证件类型代码
     */
    @ZdDzConfig(field = "sfzjlxd", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String sfzjlxd;
    /**
     * 身份证件号码
     */
    private String sfzjhm;
    /**
     * 国籍代码
     */
    @ZdDzConfig(field = "gjdm", tableName = ZdDzConstant.ZD_DZ_GJ, dmToDm = true)
    private String gjdm;
    /**
     * 联系电话
     */
    private String lxdh;
    /**
     * 变动份额
     */
    private Double bdfe2;
    /**
     * 上次取得房屋方式
     */
    @ZdDzConfig(field = "scqdfwfs", tableName = ZdDzConstant.ZD_DZ_JYFS, dmToDm = true)
    private String scqdfwfs;
    /**
     * 上次取得房屋时间
     */
    private String scqdfwsj;
    /**
     * 上次取得房屋成本
     */
    private Double scqdfwcb;
    /**
     * 备注
     */
    private String bz;
    /**
     * 所占份额
     */
    private Double szfe;
    /**
     * 房屋套次代码
     */
    @ZdDzConfig(field = "fwtcdm", tableName = ZdDzConstant.ZD_DZ_FWTC, dmToDm = true)
    private String fwtcdm;
    /**
     * 购买方直系亲属标志
     */
    @ZdDzConfig(field = "gmfzxqsbz", tableName = ZdDzConstant.ZD_DZ_GMFZXQSBZ, dmToDm = true)
    private String gmfzxqsbz;
    /**
     * 婚姻标志
     */
    @ZdDzConfig(field = "yhbz", tableName = ZdDzConstant.ZD_DZ_HYZT, dmToDm = true)
    private String yhbz;
    /**
     * 自然人标志
     */
    private String zrrbz;
}
