package cn.gtmap.hlw.core.base;


import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.IError;
import lombok.Data;

import java.io.Serializable;

/**
 * 返回公共类
 *
 * @Author admin
 * @Date 2022/12/8 17:42
 * @ClassName ReturnResult
 **/
@Data
public class ReturnResult<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 状态码
     **/
    private String code;

    /**
     * 状态信息
     **/
    private String message;

    /**
     * 状态信息
     **/
    private String msg;

    /**
     * 返回数据
     **/
    private T data;

    /**
     * 返回数据头部
     **/
    private Object head;

    private ReturnResult() {
    }

    public static ReturnResult error(IError iError) {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(iError.getCode());
        returnResult.setMessage(iError.getMsg());
        return returnResult;
    }

    public static ReturnResult error() {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode("500");
        returnResult.setMessage("系统异常，请联系管理员");
        return returnResult;
    }

    public static ReturnResult error(String code, String message) {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(code);
        returnResult.setMessage(message);
        return returnResult;
    }

    public static ReturnResult success() {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(ErrorEnum.SUCCESS.getCode());
        returnResult.setMessage(ErrorEnum.SUCCESS.getMsg());
        return returnResult;
    }

    public static ReturnResult success(Object head, Object data) {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(ErrorEnum.SUCCESS.getCode());
        returnResult.setMessage(ErrorEnum.SUCCESS.getMsg());
        returnResult.setMsg(ErrorEnum.SUCCESS.getMsg());
        returnResult.setHead(head);
        returnResult.setData(data);
        return returnResult;
    }

    public static ReturnResult success(Object data) {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(ErrorEnum.SUCCESS.getCode());
        returnResult.setMessage(ErrorEnum.SUCCESS.getMsg());
        returnResult.setData(data);
        return returnResult;
    }

    public static ReturnResult success(String msg, Object data) {
        ReturnResult returnResult = new ReturnResult();
        returnResult.setCode(ErrorEnum.SUCCESS.getCode());
        returnResult.setMessage(msg);
        returnResult.setData(data);
        return returnResult;
    }

    public ReturnResult result(String success) {
        this.setCode(success);
        return this;
    }

    public ReturnResult message(String message) {
        this.setMessage(message);
        return this;
    }

}

