/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.aop;

import cn.gtmap.hlw.core.annotation.RequestLimit;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RequestLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLimitAspect.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Pointcut(value="@annotation(requestLimit)")
    public void controllerAspect(RequestLimit requestLimit) {
    }

    @Around(value="controllerAspect(requestLimit)")
    public Object doAround(ProceedingJoinPoint joinPoint, RequestLimit requestLimit) throws Throwable {
        long period = requestLimit.period();
        long limitCount = requestLimit.count();
        String methodName = requestLimit.methodName();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            log.error(ErrorEnum.FAIL.getCode(), (Object)"\u5f53\u524d\u7ebf\u7a0b\u672a\u7ed1\u5b9aHttpServletRequest");
            return null;
        }
        HttpServletRequest request = attributes.getRequest();
        String uri = request.getRequestURI();
        String userId = SessionUtil.getUserId();
        String key = "req_limit_".concat(uri).concat(userId);
        if (StringUtils.isNotBlank((CharSequence)methodName)) {
            key = "req_limit_".concat(methodName).concat(userId);
        }
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        long currentMs = System.currentTimeMillis();
        zSetOperations.add((Object)key, (Object)currentMs, (double)currentMs);
        this.redisTemplate.expire((Object)key, period, TimeUnit.SECONDS);
        long windowStartMs = currentMs - TimeUnit.SECONDS.toMillis(period);
        zSetOperations.removeRangeByScore((Object)key, 0.0, (double)windowStartMs);
        Long count = zSetOperations.zCard((Object)key);
        if (count > limitCount) {
            log.error("\u63a5\u53e3\u62e6\u622a\uff1a{} \u8bf7\u6c42\u8d85\u8fc7\u9650\u5236\u9891\u7387\u3010{}\u6b21/{}s\u3011,\u7528\u6237\u4e3a{}", new Object[]{uri, limitCount, period, userId});
            throw new BizException(ErrorEnum.TOO_FREQUENT_VISIT);
        }
        return joinPoint.proceed();
    }
}

