package cn.gtmap.hlw.core.dto.common;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.IError;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/27
 * @description
 */
@Data
public class ResDTO<T> {
    /**
     * 响应头
     */
    private ResHeadDTO head;
    /**
     * 响应数据
     */
    private T data;

    public static ResDTO success(Object data) {
        ResDTO tResDTO = new ResDTO();
        tResDTO.setData(data);
        ResHeadDTO resHeadDTO = new ResHeadDTO();
        resHeadDTO.setStatusCode(ErrorEnum.SUCCESS.getCode());
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static ResDTO success() {
        ResDTO tResDTO = new ResDTO();
        tResDTO.setData(null);
        ResHeadDTO resHeadDTO = new ResHeadDTO();
        resHeadDTO.setStatusCode(ErrorEnum.SUCCESS.getCode());
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static ResDTO fail(String msg) {
        ResDTO tResDTO = new ResDTO();
        tResDTO.setData(new ResData());
        ResHeadDTO resHeadDTO = new ResHeadDTO();
        resHeadDTO.setStatusCode(ErrorEnum.FAIL.getCode());
        resHeadDTO.setMsg(msg);
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static ResDTO fail(String code, String msg) {
        ResDTO tResDTO = new ResDTO();
        ResHeadDTO resHeadDTO = new ResHeadDTO();
        resHeadDTO.setStatusCode(ErrorEnum.FAIL.getCode());
        resHeadDTO.setStatusCode(code);
        resHeadDTO.setMsg(msg);
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static ResDTO<String> fail(IError iError) {
        ResDTO tResDTO = new ResDTO();
        ResHeadDTO resHeadDTO = new ResHeadDTO();
        resHeadDTO.setStatusCode(ErrorEnum.FAIL.getCode());
        resHeadDTO.setStatusCode(iError.getCode());
        resHeadDTO.setMsg(iError.getMsg());
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }
}


