package cn.gtmap.hlw.core.util.pdf;

import cn.gtmap.hlw.core.constant.Constants;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @version 1.0, 2019/6/29.
 * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
 * @description 转换
 */
public class TransformUtil {

    public static final Logger LOGGER = LoggerFactory.getLogger(TransformUtil.class);

    public static void main(String[] args) {
        String id = "340122730306245";
        LOGGER.info("18位身份证：{}", idCardNumOldChangeNew(id));
    }

    /**
     * Double 转string 去除科学记数法显示
     *
     * @param d
     * @return
     */
    public static String double6ToStr(Double d) {
        if (d == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(6);
        return (nf.format(d));
    }

    public static String double2ToStr(Double d) {
        if (d == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        return (nf.format(d));
    }

    /**
     * @param
     * @return
     * @description Double转string，去除小数点后无效数据0
     * @version 2.0, 2020/4/10 9:39
     * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
     */
    public static String doubleToStrNoZeros(Double d) {
        if (d == null) {
            return "";
        }
        BigDecimal value = BigDecimal.valueOf(d);
        BigDecimal noZeros = value.stripTrailingZeros();
        String result = noZeros.toPlainString();
        return (result);
    }

    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 身份证号码转换老身份证号码15转换18位
     */
    public static String idCardNumOldChangeNew(String idCardNumOld) {
        String idCardNumNew = StringUtils.trim(idCardNumOld);
        if (StringUtils.isBlank(idCardNumNew)) {
            return "";
        } else if (18 == idCardNumNew.trim().length()) {
            return idCardNumNew;
        } else if (15 == idCardNumNew.trim().length()) {
            String id = idCardNumNew;
            id = id.length() == 15 ? id.substring(0, 6) + "19" + id.substring(6) : id;
            //乘位
            String[] c = {"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
            //补位
            String[] b = {"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
            Integer sum = 0;
            for (int i = 0; i < id.length(); i++) {
                sum = sum + Integer.parseInt(c[i]) * Integer.parseInt(String.valueOf(id.charAt(i)));
            }
            Integer index = sum % 11;
            return id + b[index];
        } else {
            return null;
        }
    }

    /**
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 身份证号码转换 18位转15位
     */
    public static String turnIdCardFrom18To15(String str) {
        if (str.length() == 18) {
            return str.substring(0, 6) + str.substring(8, 17);
        }
        return str;
    }

    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 金额转换元
     * 如果登记是万元，那么je.sz.dw=万元
     * 数据入参是登记系统的入参，单位是配置的je.sz.dw
     * 出参单位是元
     */
    public static String jeTransYuan(Object je) {
        String jeYuan = "";
        if (je == null || StringUtils.isBlank(String.valueOf(je))) {
            return jeYuan;
        }
        // 金额数值单位（元、万元、默认万元） （根据各地登记库实际单位配置）
        String jeSzDw = AppConfig.getProperty("je.sz.dw");
        if (StringUtils.isNotBlank(jeSzDw)) {
            jeSzDw = jeSzDw.trim();
        } else {
            jeSzDw = "万元";
        }
        if (StringUtils.equals(jeSzDw, Constants.WANYUAN)) {
            Double jyjg = new BigDecimal(String.valueOf(je)).multiply(BigDecimal.valueOf(10000)).doubleValue();
            jeYuan = double2ToStr(jyjg);
        } else if (StringUtils.equals(jeSzDw, Constants.YUAN)) {
            if (je instanceof Double) {
                DecimalFormat df = new DecimalFormat("##0.00");
                jeYuan = df.format(je);
            } else {
                jeYuan = String.valueOf(je);
            }
        }
        return jeYuan;

    }

    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 元转换金额
     * 如果登记是万元，那么je.sz.dw=万元
     * 数据入参是互联网+的入参，单位是元
     * 出参单位是je.sz.dw
     */
    public static String yuanTransJe(Object je) {
        String jeYuan = "";
        if (je == null || StringUtils.isBlank(String.valueOf(je))) {
            return jeYuan;
        }
        // 金额数值单位（元、万元、默认万元） （根据各地登记库实际单位配置）
        String jeSzDw = AppConfig.getProperty("je.sz.dw");
        if (StringUtils.isNotBlank(jeSzDw)) {
            jeSzDw = jeSzDw.trim();
        } else {
            jeSzDw = "万元";
        }
        if (StringUtils.equals(jeSzDw, Constants.WANYUAN)) {
            Double jyjg = new BigDecimal(String.valueOf(je)).divide(BigDecimal.valueOf(10000)).doubleValue();
            jeYuan = double6ToStr(jyjg);
        } else if (StringUtils.equals(jeSzDw, Constants.YUAN)) {
            if (je instanceof Double) {
                DecimalFormat df = new DecimalFormat("##0.00");
                jeYuan = df.format(je);
            } else {
                jeYuan = String.valueOf(je);
            }
        }
        return jeYuan;
    }

    private static Map<String, String> bdcdyhDzqllxMcMap = Maps.newHashMap();

    {
        bdcdyhDzqllxMcMap.put("GB:W", "国有建设用地使用权");
        bdcdyhDzqllxMcMap.put("JC:W", "宅基地使用权");
        bdcdyhDzqllxMcMap.put("ZC:W", "宅基地使用权");
        String jtjsydsyq = "集体建设用地使用权";
        bdcdyhDzqllxMcMap.put("JB:W", jtjsydsyq);
        bdcdyhDzqllxMcMap.put("ZB:W", jtjsydsyq);
        bdcdyhDzqllxMcMap.put("ZS:W", jtjsydsyq);
        bdcdyhDzqllxMcMap.put("ZX:W", jtjsydsyq);
    }

    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 不动产单元号转换权力类型
     */
    public static String bdcdyhTransQllx(String bdcdyh) {
        String qllx = "";
        //宗地号首字母
        if (StringUtils.isBlank(bdcdyh)) {
            return qllx;
        }
        String zdhszm = StringUtils.substring(bdcdyh, 12, 14);
        //定着物单位代码首字母
        String dzwdwdmszm = StringUtils.substring(bdcdyh, 19, 20);
        String bdcdyhDzqllxKey = zdhszm + ":" + dzwdwdmszm;
        //权利类型名称
        String qllxMc = bdcdyhDzqllxMcMap.get(bdcdyhDzqllxKey);
        // 国有建设用地使用权
        if (StringUtils.isNoneBlank(zdhszm, dzwdwdmszm) && StringUtils.equals(zdhszm, Constants.GB) && StringUtils.equals(dzwdwdmszm, Constants.W)) {
            qllx = "3";
        }
        // 宅基地使用权
        boolean flag=StringUtils.isNoneBlank(zdhszm, dzwdwdmszm)
                && (StringUtils.equals(zdhszm, "JC") || StringUtils.equals(zdhszm, "ZC"))
                && StringUtils.equals(dzwdwdmszm, "W");
        if (flag) {
            qllx = "5";
        }
        boolean flag1=StringUtils.isNoneBlank(zdhszm, dzwdwdmszm)
                && (StringUtils.equals(zdhszm, "JB") || StringUtils.equals(zdhszm, "ZB") || StringUtils.equals(zdhszm, "ZS") || StringUtils.equals(zdhszm, "ZX"))
                && StringUtils.equals(dzwdwdmszm, "W");
        // 集体建设用地使用权
        if (flag1) {
            qllx = "7";
        }
        //土地承包经营权
        boolean flag2=StringUtils.isNoneBlank(zdhszm)
                && (StringUtils.equals(zdhszm, "GD") || StringUtils.equals(zdhszm, "GE") || StringUtils.equals(zdhszm, "GF") || StringUtils.equals(zdhszm, "JD")
                || StringUtils.equals(zdhszm, "JE") || StringUtils.equals(zdhszm, "JF") || StringUtils.equals(zdhszm, "ZD") || StringUtils.equals(zdhszm, "ZE")
                || StringUtils.equals(zdhszm, "ZF"));
        if (flag2) {
            qllx = "9";
        }
        //海域使用权
        if (StringUtils.isNoneBlank(zdhszm)
                && (StringUtils.equalsAny(zdhszm, "ZH", "GH") )) {
            qllx = "13";
        }
        //无居民海岛使用权
        if (StringUtils.isNoneBlank(zdhszm)
                && (StringUtils.equalsAny(zdhszm, "GG", "ZG") )) {
            qllx = "15";
        }
        // 房屋所有权
        if (StringUtils.isNoneBlank(dzwdwdmszm)
                && StringUtils.equals(dzwdwdmszm, "F")) {
            qllx = "";
        }

        return qllx;
    }

    /**
     * 将数字字符串格式化为只保留N位小数的字符串。
     *
     * @param numberStr 输入的数字字符串
     * @return 格式化后的字符串，保留的小数位数
     */
    public static String formatToDecimalPlaces(String numberStr, int scale) {

        if (StringUtils.isBlank(numberStr)) {
            return numberStr;
        }
        try {
            // 将字符串转换为BigDecimal
            BigDecimal number = new BigDecimal(numberStr);
            // 四舍五入到小数点后N位
            number = number.setScale(scale, RoundingMode.HALF_UP);
            // 转换回字符串
            return number.toPlainString();
        } catch (NumberFormatException e) {
            // 如果输入的字符串不是有效的数字，抛出异常
            throw new IllegalArgumentException("Invalid number format");
        }
    }

}
