package cn.gtmap.hlw.core.util.ahwstface;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import com.iflytek.uccp.auth.sdk.util.sm3.SM3Digest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.TreeMap;

/**
 * 加密
 */
public class SignUtils {

    //日志
    private static Logger logger = LoggerFactory.getLogger(SignUtils.class);

    /**
     * 参数加签
     *
     * @param params 带价钱参数信息
     * @param appKey 分配的秘钥信息
     * @return
     */
    public static String getSign(TreeMap<String, String> params, String appKey) {
        String s = buildSignData(params, appKey);
        // SM3 散列
        return SM3Digest.sm3Encry(s);
    }


    /**
     * 构造签名字符串
     *
     * @param params 需要签名的参数列表
     * @param appKey 分配的应用密钥
     * @return 返回待签名的字符串
     */
    private static String buildSignData(TreeMap<String, String> params, String appKey) {
        StringBuilder data = new StringBuilder();

        int[] index = {0};
        int size = params.size();
        params.forEach((k, v) -> {
            if (StringUtils.isNotBlank(v)) {
                data.append(k + "=" + v);
                if (index[0] != size - 1) {
                    data.append("&");
                }
            }
            index[0]++;
        });
        try {
            String signDateStr = URLEncoder.encode(data + appKey, "UTF-8");
            logger.debug("待签名的字符串：{}", signDateStr);
            return signDateStr;
        } catch (UnsupportedEncodingException e) {
            throw new BizException(ErrorEnum.SERVICE_ERROR,e);
        }
    }
}
