package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxWxbl;
import cn.gtmap.hlw.core.model.WxbSaveParamsModel;

import java.math.BigInteger;
import java.util.List;

/**
 * 在线申请--闻讯笔录(GxYySqxxWxbl)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:50
 */
public interface GxYySqxxWxblRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param wxblid 主键
     * @return 实例对象
     */
    GxYySqxxWxbl get(String wxblid);

    /**
     * 新增数据
     *
     * @param gxYySqxxWxbl 实例对象
     * @return 影响行数
     */
    String save(GxYySqxxWxbl gxYySqxxWxbl);

    /**
     * 修改数据
     *
     * @param gxYySqxxWxbl 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxWxbl gxYySqxxWxbl);

    /**
     * 保存和修改数据
     *
     * @param saveParamsModel 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(WxbSaveParamsModel saveParamsModel);

    /**
     * 获取数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    List<GxYySqxxWxbl> getBySlbh(String slbh);

    /**
     * 获取数据
     *
     * @param slbh 受理编号
     * @param userGuid 用户id
     * @return 影响行数
     */
    List<GxYySqxxWxbl> getBySlbhAndUserGuid(String slbh, String userGuid);

    /**
     * 通过sqidList查询集合数据
     *
     * @param slbhList
     * @return 实例对象
     */
    List<GxYySqxxWxbl> getBySlbhList(List<String> slbhList);

    /**
     * 通过sqidList删除数据
     *
     * @param slbhList
     * @return 实例对象
     */
    int deleteBySlbhList(List<String> slbhList);

    /**
     * 根据受理编号和权利人类型查询
     *
     * @param slbh
     * @param qlrlx
     * @return
     */
    List<GxYySqxxWxbl> getBySlbhAndQlrlx(String slbh, String qlrlx);

    /**
     * 批量保存或更新
     *
     * @param gxYySqxxWxblList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdateBatch(List<GxYySqxxWxbl> gxYySqxxWxblList);
}

