package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/21
 * @description
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WctJyHsxx implements Serializable {
    private static final long serialVersionUID = -3385773151983920225L;
    /**
     * 核税信息ID
     */
    private String hsxxid;

    private String hdjsjg;

    /**
     * 完税状态
     */
    private String wszt;

    /**
     * 完税状态名称
     */
    private String wsztmc;

    private String ynsehj;

    private String jmsehj;

    private String sjyzhj;

    /**
     * 税务机关代码
     */
    private String swjgdm;

    /**
     * 纳税人识别号
     */
    private String nsrsbh;

    /**
     * 税票号码
     */
    private String sphm;

    /**
     * 申请id
     */
    private String sqid;

    /**
     * 权利人类别
     */
    private String qlrlb;

    /**
     * 权利人类别名称
     */
    private String qlrlbmc;

    /**
     * 执收单位代码
     */
    private String zsdwdm;

    /**
     * 业务系统受理编号
     */
    private String ywxtslbh;

    /**
     * 执收单位名称
     */
    private String zsdwmc;

    /**
     * 收费收税信息id
     */
    private String sfssxxid;

    /**
     * 是否土地收益金（0:否，1：是）
     */
    private String sftdsyj;

    /**
     * 缴税方式（1：一卡清缴税模式，2：线下缴税）
     */
    private String jsfs;

    /**
     * 纳税人名称
     */
    private String nsrmc;

    /**
     * 存有效订单编号，作废要清空）
     */
    private String ddbh;
    /**
     * 缴库状态(0:未缴库，1:已缴库)
     */
    private String jkzt;
}
