package cn.gtmap.hlw.core.model;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 不动产用户表(GxYyUser)表实体类BO
 *
 * @author makejava
 * @since 2023-06-01 11:39:30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyUser implements Serializable {
    private static final long serialVersionUID = -5132994714915296267L;
    /**用户GUID*/
    private String userGuid;

   /**用户账号*/
    private String userName;

   /**用户密码*/
    private String userPwd;

   /**用户姓名*/
    private String realName;

   /**机构地址*/
    private String jgDz;

   /**1:管理员 2:普通用户 3:中介 4:开发商 5:银行*/
    private Integer role;

   /**机构名称*/
    private String jgName;

    private String lxDh;

   /**是否可用1：可用 0：不可用*/
    private Integer isValid;

   /**创建日期*/
    private Date createDate;

   /**编辑日期*/
    private Date editDate;

    /**证件类型 */
    private String zjType;

    private String userZjid;

   /**用户手机号*/
    private String userPhone;

   /**微信的openid*/
    private String userCode;

   /**支付宝登陆所得ID*/
    private String zfbUserid;

   /**政务网用户ID*/
    private String onemapId;

    /**区域代码*/
    private String qydm;

   /**禁用理由*/
    private String validReason;

   /**是否验证（Y:已验证，N:未验证）*/
    private String sfyz;

   /**验证方式（0:普通验证,1:OCR,2:人脸,3:其他系统）*/
    private String yzfs;

   /**是否需要CA登录(0：是需要，1：否不需要)*/
    private String isCalogin;

   /**邮箱*/
    private String email;

   /**禁用次数*/
    private Integer validCount;

   /**禁用开始日期*/
    private String validStartdate;

   /**禁用结束日期*/
    private String validEnddate;

   /**用户姓名脱敏*/
    private String realNameTm;

   /**用户联系电话脱敏*/
    private String lxDhTm;

   /**用户证件ID脱敏*/
    private String userZjidTm;

   /**邮箱脱敏*/
    private String emailTm;

   /**REGISTER用户主键*/
    private String registerId;

   /**预约黑名单（0:否，1:是）*/
    private String yyhmd;

   /**预约黑名单修改人*/
    private String yyhmdUpdateUser;

   /**预约黑名单修改时间*/
    private Date yyhmdUpdateTime;

   /**柜面机窗口电脑IP*/
    private String sysIp;

   /**用户账号操作状态（0：管理员新增用户，1；管理员账户重置，2：其他）*/
    private String yhzhczzt;

   /**注册来源*/
    private String zcly;

   /**用户密码修改时间*/
    private Date yhmmUpdateTime;

   /**天印签字accountId值*/
    private String qzAccountid;

   /**扬州是否需要统一认证 0不需要 1需要*/
    private String sfxytyrz;

   /**工号*/
    private String gh;

   /**预审区域权限（大庆）*/
    private String ysqyqx;

    /**备注*/
    private String bz;

   /**政务网用户accountid*/
    private String onemapAccountid;

   /**是否法人（0:否，1:是）*/
    private String sffr;

   /**审核状态：0待审核，1审核通过，2审核不通过*/
    private String shzt;

   /**记录所在地的行政区划(市信息)*/
    private String dlszxzqdm;

   /**资格证书编号*/
    private String zgzhbh;

   /**是否指纹登录*/
    private String iszwlogin;

    /**是否有签章权限（1:有，:0或空:无）*/
    private String sfyqzqx;
    /**
     * 内外网标识（1：内网， 2：外网 ）
     */
    private String nwwbs;
    /**
     * 签名
     */
    private String qm;
}

