package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.WctJySqrxx;

import java.util.List;
import java.util.Map;

/**
 * (WctJySqrxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJySqrxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJySqrxx get(String id);

    /**
     * 新增数据
     *
     * @param wctJySqrxx 实例对象
     * @return 影响行数
     */
    void save(WctJySqrxx wctJySqrxx);

    /**
     * 修改数据
     *
     * @param wctJySqrxx 实例对象
     * @return 影响行数
     */
    void update(WctJySqrxx wctJySqrxx);

    /**
     * 批量新增数据
     *
     * @param sqrxxList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<WctJySqrxx> sqrxxList);

    /**
     * 根据map查询
     *
     * @param map 实例对象
     * @return List<WctJySqrxx>
     */
    List<WctJySqrxx> getListByMap(Map<String, Object> map);
    /**
     * 根据sfssxxid查询数据
     *
     * @param sfssxxid 实例对象
     * @return
     */
    List<WctJySqrxx> listBySfssxxid(String sfssxxid);
    /**
     * 根据sfssxxid删除
     * @param sfssxxid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteBySfssxxid(String sfssxxid);
}

