package cn.gtmap.hlw.core.dto.sqxx.tz;

import cn.gtmap.hlw.core.base.BasePage;
import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/29 16:23
 * @description MySqxxParamsDTO
 */
@Data
public class SqxxTzParamsDTO extends BasePage {
    /**
     * process 台账可能没有processId,那就上市 gx_yy_menu.FUNCTION_MENU_ID
     */
    private String processId;
    /**
     * 领域事件代码
     */
    private String lysjdm;
    /**
     * 当前用户信息
     */
    /**
     * 当前登陆人所属角色  此字段不作为查询条件
     */
    private String roleId;
    /**
     * 登陆人 此字段对应 gx_yy_sqxx.create_userid
     */
    private String userGuid;
    /**
     * 创建人名称
     */
    private String userName;
    /**
     * 当前登陆人所属部门  此字段不作为查询条件，放在orgIdList作为查询条件
     */
    private String orgId;
    /**
     * 审核人
     */
    private String editUser;
    /**
     * 审核部门
     */
    private String shOrgId;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 受理状态
     */
    private String slzt;

    /**
     *查询条件
     */
    /**
     * 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id
     */
    private List<String> orgIdList;
    /**
     * 需要查询的SLZT gx_yy_sqxx.slzt
     */
    private List<String> slztList;
    /**
     * 受理编号 gx_yy_sqxx.slbh
     */
    private String slbh;
    /**
     * 业务系统受理编号 gx_yy_sqxx.ywxtslbh
     */
    private String ywxtslbh;
    /**
     * 权利人名称 gx_yy_sqxx.qlrmc ；不区分是否组合登记，都查
     */
    private String qlrmc;
    /**
     * 权利人名称 gx_yy_sqxx.ywrmc ；不区分是否组合登记，都查
     */
    private String ywrmc;
    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlx;
    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private List<String> sqlxList;
    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlxmh;
    /**
     * 坐落 gx_yy_sqxx.zl 支持模糊查询
     */
    private String zl;
    /**
     * 税务状态 gx_yy_sqxx.swzt
     */
    private List<String> swztList;
    /**
     * 缴费状态 gx_yy_sqxx.jfzt
     */
    private List<String> jfztList;
    /**
     * 开始时间：yyyy-mm-dd 00:00:00  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date kssj;

    /**
     * 开始时间：yyyy-mm-dd 23:59:59  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jssj;

    private String jfzt;
    private String isBank;
    /**
     * 是否需要云签 0：否 1：是，（整个流程是否需要发起云签）
     */
    private String sfyq;
    /**
     * 数据源
     */
    private String sjy;
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 是否查询登录用户角色办件(false:否，true:是)
     */
    private String sfcxdlyhjsbj;
    /**
     * 岗位
     */
    private String gw;
    /**
     * 需要查询的SLZT gx_yy_sqxx.sqlx
     */
    private List<String> noYqList;
    /**
     * 是否认证
     */
    private String sfrz;
    /**
     * 土地证号
     */
    private String tdzh;
    /**
     * 匹配状态
     */
    private String ppzt;
    /**
     * 权利人名称集合
     */
    private List<String> qlrmcList;
    /**
     * 登记中心
     */
    private String djzx;
}
