package cn.gtmap.hlw.core.dto.exchange.push;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 收费收税信息
 */
@Data
public class PushSfssxxDTO {
    /**
     * 收费收税信息id
     */
    private String sfssxxid;

    /**
     * 项目主键
     */
    private String xmid;

    /**
     * 权利人类别（1:权利人，2义务人，3抵押权人,4借款人，5：原抵押权人，6：公积金抵押权人）
     */
    private String qlrlb;

    /**
     * 区县代码
     */
    private String qxdm;

    /**
     * 执收单位名称
     */
    private String zsdwmc;

    /**
     * 执收单位代码
     */
    private String zsdwdm;

    /**
     * 内网受理编号(蚌埠为互联网slbh)
     */
    private String nwslbh;

    /**
     * 缴费状态(0:未缴费 1:部分缴费 2:已缴费)
     */
    private String jfzt;

    /**
     * 是否月结(0：否；1：是)
     */
    private String sfyj;
    /**
     * 登记费信息
     */
    private PushDjxxDTO djxx;
    /**
     * 核税信息
     */
    private PushHsxxDTO hsxx;
    /**
     * 订单信息
     */
    private PushDdxxDTO ddxx;
    /**
     * 申请人信息
     */
    private List<PushSqrxxDTO> sqrxxList;
}
