package cn.gtmap.hlw.core.dto.notice.wdxx;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/8/19 16:43
 * @description 未读通知
 */
@Data
public class WdxxWdtzResultDTO {
    /**
     * 我的邮箱表id
     */
    private String id;

    /**
     * 信息类型（关联信息字典表）
     */
    private String xxlx;
    /**
     * 信息类型名称
     */
    private String xxlxmc;

    /**
     * 创建人（user表guid）
     */
    private String cjr;

    /**
     * 接收人（user信息表guid）
     */
    private String jsr;

    /**
     * 业务号（推送时可将推送业务的业务号送过来，关联到该业务）
     */
    private String ywh;

    /**
     * 标题
     */
    private String bt;

    /**
     * 副标题
     */
    private String fbt;

    /**
     * 内容
     */
    private String nr;

    /**
     * 是否已读（0：未读，1已读）
     */
    private String sfyd;

    /**
     * 创建时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date cjsj;

    /**
     * 阅读时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date ydsj;

    /**
     * 业务类型（1:申请信息,2:预约信息）
     */
    private String ywlx;
}
