package cn.gtmap.hlw.core.constant.redis;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/19 14:34
 * @description Redis常量
 */
public class RedisKeyConstant {

    /**
     * 登录 - 密码登录错误次数key
     */
    public static final String LOGIN_ERROR_COUNT = "passworderror_count:${userGuid}";
    /**
     * 全局测试数据配置(true为启用测试数据)，正式上线请删除该配置项
     */
    public static final String WHOLE_TEST_DATA = "whole.test.data";
    /**
     * 缴费缴税全局测试数据配置(true为启用测试数据)，正式上线请删除该配置项
     */
    public static final String WHOLE_JFJS_TEST_DATA = "whole.jfjs.test.data";
    /**
     * 预约热点数据
     */
    public static final String ORDER_DATE_ORGID = "order_date_orgid:";

    /**
     * 字典类型
     */
    public static final String GX_YY_ZD_TYPE = "GX_YY_ZD_TYPE:";
    /**
     * 字典类型-对照
     */
    public static final String GX_YY_ZD_DZ = "GX_YY_ZD_DZ:";
    /**
     * 字典--申请类型
     */
    public static final String GX_YY_ZD_SQLX = "GX_YY_ZD_SQLX:";
    /**
     * 字典--登记原因
     */
    public static final String GX_YY_ZD_DJYY = "GX_YY_ZD_DJYY:";

    /**
     * token key值
     */
    public static final String TOKEN_REDIS_KEY = "accessToken:";

    /**
     * SecretKey
     */
    public static final String SIGN_SECRET_KEY = "sign_secret_key:";
    /**
     * SecretKey
     */
    public static final String SIGN_NONCE = "sign_nonce:";
    /**
     * 是否登出
     */
    public static final String TOKEN_PUBLISH = "accessToken.publish";


    /**
     * 接口Token
     */
    public static final String JKTOKEN_REDIS_KEY = "jkToken:";
    /**
     * 推送登记-key
     */
    public static final String PUSHDj_REDIS_KEY = "pushDjSlbh:";

    /**
     * 短信验证码 key值
     */
    public static final String SMS_YZM_LXDH = "smsYzmLxdh:";

    /**
     * 附件下载tikcet key值  "download_ticket:${fjid}=${ticket}  时效30秒
     */
    public static final String FJ_DOWNLOAD_TICKET = "download_ticket:";

    /**
     * 二维码tikcet key值 ticket时效默认半小时
     */
    public static final String FJ_SMSCFJ_TICKET = "smscfj:";

    /**
     * 二维码token key值
     */
    public static final String FJ_TOKEN_TICKET = "token:";

    /**
     * 云签发起时间间隔限制key值
     */
    public static final String SIGNFLOWS_TIME_LIMIT = "signflows_time_limit:";

    /**
     * 排除加密url
     */
    public static final String AUTH_FILTER_EXCLUDE_URLS = "auth.filter.exclude.urls";
    /**
     * pc端加密url
     */
    public static final String AUTH_FILTER_PC_URLS = "auth.filter.pc.urls";
    /**
     * 跳过过滤器的url
     */
    public static final String AUTH_FILTER_SKIP_URLS = "auth.filter.skip.urls";
    /**
     * 移动端加密url
     */
    public static final String AUTH_FILTER_PHONE_URLS = "auth.filter.phone.urls";
    /**
     * 登录地址
     */
    public static final String LOGIN_URLS = "login.urls";
    /**
     * 登出地址
     */
    public static final String LOGIN_OUT_URLS = "login.out.urls";

    /**
     * 是否全部加密：0：是 1：否
     */
    public static final String SM2_ENCODE_STAUS = "sm2.encode.staus";

    /**
     * 是否开启数字签名：1：是 0：否
     */
    public static final String SM2_NEED_SIGNATURE = "sm2.need.signature";
    /**
     * 开启开发调试，返回明文
     */
    public static final String SM2_DEBUG_STAUS = "sm2.debug.staus";

    /**
     * 税费厂家
     */
    public static final String YKQ_SCDD_SFCJ = "ykq.scdd.sfcj";
    /**
     * 财政厂家
     */
    public static final String YKQ_SCDD_CZCJ = "ykq.scdd.czcj";
    /**
     * 是否税费统缴
     */
    public static final String YKQ_SCDD_SFSFTJ = "ykq.scdd.sfsftj";

    /**
     * 手机扫码上传附件地址
     */
    public static final String WECHAT_PAGE_URL = "wechat.page.url";

    /**
     * md5 盐值
     */
    public static final String MD5_SALT = "md5.salt";

    /**
     * 国图大云token相关配置
     */
    public static final String REALESTATE_EXCHANGE_GRANT_TYPE = "realestate.exchange.grant.type";
    public static final String REALESTATE_EXCHANGE_CLIENT_ID = "realestate.exchange.client.id";
    public static final String REALESTATE_EXCHANGE_CLIENT_SECRET = "realestate.exchange.client.secret";
    public static final String REALESTATE_EXCHANGE_USERNAME = "realestate.exchange.username";
    public static final String REALESTATE_EXCHANGE_PASSWORD = "realestate.exchange.password";

    /**
     * 文件夹目录Id
     */
    public static final String WWSQ_TS_FJXX_UPLOAD_NODEID = "wwsq.ts.fjxx.upload.nodeId";
    /**
     * 文件上传者， 使用UserDto 中的id 字段
     */
    public static final String WWSQ_TS_FJXX_UPLOAD_OWNER = "wwsq.ts.fjxx.upload.owner";
    /**
     * 存储空间
     */
    public static final String WWSQ_TS_FJXX_UPLOAD_SPACECODE = "wwsq.ts.fjxx.upload.spaceCode";
    /**
     * 应用Id
     */
    public static final String WWSQ_TS_FJXX_UPLOAD_CLIENTID = "wwsq.ts.fjxx.upload.clientId";
    /**
     * 应用ip
     */
    public static final String WWSQ_TS_FJXX_UPLOAD_IP = "wwsq.ts.fjxx.upload.ip";

    /**
     * mq 发送消息开关
     */
    public static final String MQ_SENDMSG_ENABLE = "mq.sendMsg.enable";
    /**
     * 模板打印模板地址前缀
     */
    public static final String LCDY_PDF_PATH = "lcdy.pdf.path";
    /**
     * 生成订单-缴费方式
     */
    public static final String SCDD_JFFS = "scdd.jffs";
    /**
     * 推送税务-附件类型
     */
    public static final String YC_TSSW_FJLX = "yc.tssw.fjlx";

    /**
     * 文件中心地址
     */
    public static final String FILECENTER_URL = "fileCenter.url";

    /**
     * e签宝-应用密钥
     */
    public static final String ESIGN_APPKEY = "esign.appkey";
    /**
     * e签宝-应用id
     */
    public static final String ESIGN_APPID = "esign.appId";

    /**
     * 土地信息key值
     */
    public static final String YC_TDXX = "YC.TDXX:";

    /**
     * 电子证照查询码
     */
    public static final String DZZZ_QUERYCODE = "yc.dzzz.querycode:";
    /**
     * 生成订单 xttype
     */
    public static final String YKQ_SCDD_XTTYPE = "ykq.scdd.xtType";

    /**
     * 全部部门
     */
    public static final String ORG_ALL = "org.all";
    /**
     * 全部字典
     */
    public static final String ZDTYPE_ALL = "zdtype.all";
    /**
     * 税务机构代码
     */
    public static final String SW_SWJGDM = "sw.swjgdm";
    /**
     * 导出
     */
    public static final String EXPORT = "export:";

    /**
     * 电子证照应用名称
     */
    public static final String DZZZ_TOKEN_YYMC = "dzzz.token.yymc";
    /**
     * 电子票据下载地址
     */
    public static final String DZPJ_DOWNLOAD_URL = "dzpj.download.url";
    /**
     * 上传文件类型
     */
    public static final String UPLOAD_FILE_TYPE = "upload.file.type";
    /**
     * 互联网根据token获取用户信息地址
     */
    public static final String HLW_GETUSERINFO_URL = "hlw.getUserInfo.url";
    /**
     * 一窗推送登记是否月结
     */
    public static final String YC_TSDJ_SFYJ = "yc.tsdj.sfyj";
    /**
     * 一窗转移申请类型
     */
    public static final String YC_ZY_SQLX = "yc.zy.sqlx";
    /**
     * 一窗抵押申请类型
     */
    public static final String YC_DY_SQLX = "yc.dy.sqlx";
    /**
     * 一窗在线办件率
     */
    public static final String YC_ZXBJL = "yc.zxbjl";
    /**
     * 不动产查询件数
     */
    public static final String YC_BDCCXJS = "yc.bdccxjs";
    /**
     * 转移在线办件数
     */
    public static final String YC_ZYZXBJS = "yc.zyzxbjs";
    /**
     * 转移登记在线办理率
     */
    public static final String YC_ZYZXBLL = "yc.zyzxbll";
    /**
     * 抵押在线办件数
     */
    public static final String YC_DYZXBJS = "yc.dyzxbjs";
    /**
     * 转移登记在线办理率
     */
    public static final String YC_DYZXBLL = "yc.dyzxbll";
    /**
     * 不动产查询在线查询率
     */
    public static final String YC_BDCCXCXL = "yc.bdccxcxl";

    /**
     * 一窗查询宗地图默认图片
     */
    public static final String YC_QUERY_ZDT_MRTP = "yc.wwsq.query.zdt.mrtp";

    /**
     * 一窗查询次数
     */
    public static final String YC_QUERY_CXCS = "CXCS:";
    /**
     * 一窗日志地址
     */
    public static final String YC_PLUMELOG_IP = "yc.plumelog.url";

    /**
     * 一窗查询默认部门名称、统一信用代码的角色
     */
    public static final String YC_CXMRBMMC_ROLE = "yc.cxmrbm.role";

    /**
     * 我的常州APP扫码轮询标识
     */
    public static final String YC_MYCZ_SCAN_LOGIN = "yc.mycz.scan.login";

    /**
     * 我的常州APP人脸轮询标识
     */
    public static final String YC_MYCZ_SCAN_YZ = "yc.mycz.scan.yz";

    /**
     * 我的常州token标识
     */
    public static final String YC_MYCZ_MINIPROGRAM_TOKEN = "yc.mycz.miniprogram.token";

    /**
     * 苏服办APP人脸用户信息存储标识
     */
    public static final String YC_SFB_FACE = "yc.sfb.face:";

    /**
     * 苏服办APP人脸轮询标识
     */
    public static final String YC_SFB_SCAN_YZ = "yc.sfb.scan.yz";

    /**
     * 苏服办APP扫码登录轮询标识
     */
    public static final String YC_SFB_SCAN_LOGIN = "yc.sfb.scan.login";

    public static final String QUERY_DZZZ_CXMD = "query.dzzz.cxmd";

    /**
     * 电子证照查询，存储 zzbs到缓存中
     */
    public static final String QUERY_DZZZ_ZZJS = "query.dzzz.zzjs";

    /**
     * 电子证照查询，存储 cqzh 到缓存中
     */
    public static final String QUERY_BDCQZ_QUERY = "query.bdcqz.query";
    /**
     * 电子证照查询，存储 djsj 到缓存中
     */
    public static final String QUERY_DJSJ_QUERY = "query.djsj.query";

    /**
     * 不需要房查的登记原因
     */
    public static final String YC_NOT_NEED_FC_DJYY = "yc.not.need.fc.djyy";
    /**
     * 需要房查的房屋用途
     */
    public static final String YC_NEED_FC_FWYT = "yc.need.fc.fwyt";

    /**
     * 角色代码-留言回复
     */
    public static final String JSDM_LYHF = "jsdm.lyhf";

    /**
     * 角色代码-预约查看
     */
    public static final String JSDM_YYCK = "jsdm.yyck";

    /**
     * 不推送领证人作为代理人
     */
    public static final String YC_PUSH_NOTPUSHWLXXDLR = "yc.push.notPushWlxxDlr";

    /**
     * 是否开启产权办件授权：0：否 1：是
     */
    public static final String YC_CQBJSQ_ISOPEN = "yc.cqbjsq.isopen";

    /**
     * 线下缴税错误次数key
     */
    public static final String XXJS_ERROR_COUNT = "${userGuid}_xxjs_count";

    /**
     * 个人预约申请类型
     */
    public static final String YC_GR_YYSQLX = "yc.gr.yysqlx";

    /**
     * 全部用户
     */
    public static final String USER_ALL = "user.all";
    public static final String USER_ALLSIMPLE = "user.allsimple";

    /**
     *
     */
    public static final String Menu_Show_Only_Favorties = "menu.show.only.favorties";

    /**
     * 不动产单元号重复办理  过滤的slzt
     */
    public static final String YC_BDCDYH_CFBL_SLZT = "yc.bdcdyh.cfbl.slzt";

    /**
     * 一件事超时时间
     */
    public static final String YC_ONETHING_TIMEOUT = "yc.onething.timeout";

    /**
     * 推送权利人权利比例格式--小数
     */
    public static final String YC_PUSH_QLR_QLBL_XS = "yc.push.qlr.qlbl.xs";
    /**
     * 减免附件类型
     */
    public static final String YC_JM_FJLX = "yc.jm.fjlx";

    /**
     * 电子证照类型编码
     */
    public static final String DZZZ_TYPECODE = "yc.dzzz.typeCode";

    /**
     * 生成订单-不含税置空税费厂家
     */
    public static final String SCDD_BHS_ZKSFCJ = "scdd.bhs.zksfcj";
    /**
     * 房屋套次验证受理状态
     */
    public static final String FWTC_CHECK_SLZT = "fwtc.check.slzt";

    /**
     * 文件下载basekey
     */
    public static final String FJ_DOWN_BASE = "fj_down_base";
    /**
     * 是否根据流程判断是否月结
     */
    public static final String YC_SFYJ_BY_LC = "yc.sfyj.by.lc";
    /**
     * 一窗首页-办件统计是否增加reids缓存
     */
    public static final String YC_BJLTJ_REDIS = "yc.bjltj.redis";
    /**
     * 一窗首页-办件统计结果
     */
    public static final String YC_BJLTJ_RESULT = "yc.bjltj.result";
    /**
     * 一窗过户信息是否根据审核部门id查询
     */
    public static final String YC_GHXX_QUERY_SHBMID_STAUS = "yc.ghxx.query.shbmid.staus";
    /**
     * 一窗过户信息查询受理状态
     */
    public static final String YC_GHXX_QUERY_SLZT = "yc.ghxx.query.slzt";
    /**
     * 过户信息未审核审批状态
     */
    public static final String YC_GHXX_QUERY_WSH_SPZT = "yc.ghxx.query.wsh.spzt";
    /**
     * 一窗过户信息查查询是否根据区域代码查询
     */
    public static final String YC_GHXX_QUERY_QYDM_SATUS = "yc.ghxx.query.qydm.status";
    /**
     * 常州大数据局item_name
     */
    public static final String CZ_DSJJ_ITEMNAME = "cz.dsjj.itemname";
    /**
     * 常州大数据局item_code
     */
    public static final String CZ_DSJJ_ITEMCODE = "cz.dsjj.itemcode";
    /**
     * 常州大数据局account
     */
    public static final String CZ_DSJJ_ACCOUNT = "cz.dsjj.account";
    /**
     * 常州大数据局password
     */
    public static final String CZ_DSJJ_PASSWORD = "cz.dsjj.password";
    /**
     * 常州大数据局appKey
     */
    public static final String CZ_DSJJ_APPKEY = "cz.dsjj.appKey";
    /**
     * 常州大数据局appSecret
     */
    public static final String CZ_DSJJ_APPSECRET = "cz.dsjj.appSecret";

    /**
     * 一窗是否操作节点信息
     */
    public static final String YC_SFCZJDXX_STATUS = "yc.sfczjdxx.satus";

    /**
     * 一窗江苏政务appid
     */
    public static final String YC_JSZW_APPID = "yc.jszw.appid";

    /**
     * 一窗 常州app返回参数解密sm4key
     */
    public static final String YC_CZAPP_SM4KEY = "yc.czapp.sM4Key";

    /**
     * 一窗 存储 无房证明 到缓存中
     */
    public static final String YC_WFZM = "yc.wfzm";
    /**
     * 一窗 存储 登记簿 到缓存中
     */
    public static final String YC_DJB = "yc.wfzm";

    /**
     * 一窗 登记费收费项目代码
     */
    public static final String YC_DJF_SFXMDM = "yc.djf.sfxmdm";
    /**
     * 单独核税申请类型
     */
    public static final String YC_DDHS_SQLX = "yc.ddhs.sqlx";
    /**
     * 合同附件ip
     */
    public static final String YC_HT_FJ_IP = "yc.ht.fj.ip";
    /**
     * 公证书附件ip
     */
    public static final String YC_GZS_FJ_IP = "yc.gzs.fj.ip";

    public static final String YC_CONFIG_LOGIN = "yc.config.login";

    public static final String YC_CONFIG_PC = "yc.config.pc";
    /**
     * 合同信息，套内面积保存，预告申请类型
     */
    public static final String YC_HTXX_TNMJ_SAVE_YG_SQLX = "yc.htxx.tnmj.save.yg.sqlx";
    /**
     * 过户信息审核推送登记
     */
    public static final String YC_GHXXSH_TSDJ = "yc.ghxxsh.tsdj";

    /**
     * 政务服务业务中枢推送创建用户id
     */
    public static final String YC_ZWFWYWZS_CREATE_USERID = "yc.zwfwywzs.create.userid";
    /**
     * 承包经营权网签-应用id
     */
    public static final String YC_CBJYQWQ_APPID = "yc.cbjyqwq.appId";
    /**
     * 承包经营权网签-应用key
     */
    public static final String YC_CBJYQWQ_APPKEY = "yc.cbjyqwq.appKey";
    /**
     * 房屋套次证明查询他人角色
     */
    public static final String YC_FWTCZM_CXTR_ROLEID = "yc.fwtczm.cxtr.roleid";
    /**
     * 银行直连生成pdf领域事件
     */
    public static final String YHZL_CREATEPDF_LYSJ_SQLX = "yhzl.createpdf.lysj";
    /**
     * 银行直连成功受理状态
     */
    public static final String YHZL_SUCCESS_SLZT = "yhzl.success.slzt";

    public static final String YC_BATCH_DETAIL_NOTAUTODYMJ = "yc.batch.detail.notAutoDymj";
    /**
     * 打印状态
     */
    public static final String YC_DYZT = "dyzt:";

}
