package cn.gtmap.hlw.coredk.dto.olcommon.kqtb;

import lombok.Data;

import java.util.Date;

/**
 * 跨江通办附件信息
 *
 * @author <a href="mailto:chengong@gtmap.cn">chengong</a>
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Data
public class CrossRiverFjxxDTO {

    /**
     * 附件id
     */
    private String fjid;

    /**
     * 附件名称
     */
    private String fjmc;

    /**
     * 项目id
     */
    private String xmid;

    /**
     * 附件类型（gx_yy_zd_fj.dm或者页面生成各地区唯一附件类型代码）
     */
    private String fjlx;

    /**
     * 文件路径
     */
    private String filepath;

    /**
     * 文件名称
     */
    private String filemc;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建用户
     */
    private String createUser;

    /**
     * 文件中心ID
     */
    private String wjzxId;

    /**
     * 文件中心下载URL
     */
    private String wjzxDownUrl;

    /**
     * ftp上传url
     */
    private String ftpUrl;

    /**
     * 文件中心附件名称（带后缀）
     */
    private String wjzxFjmc;

    /**
     * 是否为部门附件;0否,1是
     */
    private String sfbmfj;

    /**
     * 文件中心顺序号(传给登记的顺序)
     */
    private Integer wjzxSxh;

    /**
     * 文件中心存储状态（0:未上传，1：上传中，2：已上传,3:已失效）
     */
    private String wjzxcczt;

    /**
     * 申请id
     */
    private String sqid;

    /**
     * 附件来源0:互联网；1:登记系统，2:交易系统,3:e签名，4:税务系统
     */
    private String fjly;

    /**
     * 审核状态（0:未审核，1：审核中，2：审核通过，3:审核未通过）
     */
    private String shzt;

    /**
     * IP地址
     */
    private String ip;

    /**
     * MAC地址
     */
    private String mac;

    /**
     * 用于传输附件
     */
    private String base64;
}
