package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jkgl.xtjr.XtjrPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyXtjr;

import java.util.List;

/**
 * 系统接入表(GxYyXtjr)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:48:08
 */
public interface GxYyXtjrRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyXtjr get(String id);

    /**
     * 获取系统接入表的全部数据
     *
     * @return 实例对象集合
     */
    List<GxYyXtjr> getAll();

    /**
     * 新增数据
     *
     * @param gxYyXtjr 实例对象
     * @return 影响行数
     */
    void save(GxYyXtjr gxYyXtjr);

    /**
     * 修改数据
     *
     * @param gxYyXtjr 实例对象
     * @return 影响行数
     */
    void update(GxYyXtjr gxYyXtjr);

    /**
     * 获取接入系统信息
     *
     * @param xzqydm
     * @param xtdm
     * @return
     */
    GxYyXtjr query(String xzqydm, String xtdm);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return
     */

    PageInfo<GxYyXtjr> queryPage(XtjrPageParamsDTO paramsDTO);

    /**
     * 删除数据的条数
     *
     * @param id 主键
     * @return 删除数据条数
     */
    int delete(String id);

    /**
     * 保存更新
     *
     * @param gxYyXtjr
     */
    void saveOrUpdate(GxYyXtjr gxYyXtjr);


}

