package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyFjxx;

import java.util.List;
import java.util.Map;

/**
 * (GxYyFjxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYyFjxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param fjid 主键
     * @return 实例对象
     */
    GxYyFjxx get(String fjid);

    /**
     * 通过sqid, fjlx查询集合数据
     *
     * @param sqid
     * @param fjlx
     * @return 实例对象
     */
    List<GxYyFjxx> getFjxxBySqidAndFjlx(String sqid, String fjlx);

    /**
     * 通过sqid, fjlxList查询集合数据
     *
     * @param sqid
     * @param fjlxList
     * @return 实例对象
     */
    List<GxYyFjxx> getFjxxBySqidAndFjlxList(String sqid, List<String> fjlxList);

    /**
     * 通过sqid, fjlx删除集合数据
     *
     * @param sqid
     * @param fjlx
     * @return 实例对象
     */
    int deleteFjxxBySqidAndFjlx(String sqid, String fjlx);

    /**
     * 新增数据
     *
     * @param gxYyFjxx 实例对象
     * @return 影响行数
     */
    void save(GxYyFjxx gxYyFjxx);

    /**
     * 修改数据
     *
     * @param gxYyFjxx 实例对象
     * @return 影响行数
     */
    void update(GxYyFjxx gxYyFjxx);

    /**
     * 新增或修改数据
     *
     * @param gxYyFjxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyFjxx gxYyFjxx);

    /**
     * 根据附件类型和申请id查询附件信息
     *
     * @param fjlx 附件类型
     * @param sqid 申请id
     * @return:List<GxYyFjxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyFjxx> getFjxxListByFjlxAndSqid(String fjlx, String sqid);

    /**
     * 根据xmid去查询具体附件信息
     *
     * @param xmid
     * @return
     */
    List<GxYyFjxx> getByFjxmid(String xmid);

    /**
     * 根据xmid集合去查询具体附件信息
     *
     * @param xmids
     * @return
     */
    List<GxYyFjxx> getByFjxmids(List<String> xmids);

    /**
     * 删除数据
     *
     * @param fjid 附件ID
     * @return 影响行数
     */
    int delete(String fjid);

    /**
     * 根据map去查询具体附件信息
     *
     * @param map
     * @return
     */
    List<GxYyFjxx> getJsswFjxxListByMap(Map<String, Object> map);

    /**
     * 批量插入
     *
     * @param fjxxList
     * @return
     */
    void saveBatch(List<GxYyFjxx> fjxxList);

    /**
     * 根据fjidList集合去查询具体附件信息
     *
     * @param fjidList
     * @return
     */
    List<GxYyFjxx> list(List<String> fjidList);

    /**
     * 根据fjlxList sqidList集合去查询具体附件信息
     *
     * @param fjlxList
     * @param sqidList
     * @return
     */
    List<GxYyFjxx> getByFjlxListAndSqidList(List<String> fjlxList, List<String> sqidList);

    /**
     * 根据受理编号和fjlx获取附件信息集合
     *
     * @param slbh
     * @param fjlx
     * @return
     */
    List<GxYyFjxx> getFjxxListBySlbhAndFjlx(String slbh, String fjlx);

    /**
     * 根据受理编号获取附件信息集合
     *
     * @param slbh
     * @return
     */
    List<GxYyFjxx> getFjxxListBySlbh(String slbh);

    /**
     * 根据附近类型和证件号获取附件
     *
     * @param filx
     * @param zjhList
     * @param xmid
     * @return
     */
    List<GxYyFjxx> getByFjxmid(String filx, List<String> zjhList, String xmid);

    /**
     * 根据受理编号和fjlx、qlrzjhList获取附件信息集合
     *
     * @param slbh
     * @param fjlx
     * @param qlrzjhList
     * @return
     */
    List<GxYyFjxx> getFjxxListBySlbhAndFjlxAndZjh(String slbh, String fjlx, String qlrzjhList);

    /**
     * 批量更新
     *
     * @param fjxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveOrUpdateBatch(List<GxYyFjxx> fjxxList);

    /**
     * 根据slbh和附件类型删除
     *
     * @param slbh
     * @param fjlxs
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delBySlbhAndFjlxs(String slbh, List<String> fjlxs);

    /**
     * 根据sqid和fjlx获取获取附件
     *
     * @param sqid
     * @param fjlx
     */
    List<GxYyFjxx> getFjxxListBySqidAndFjlx(String sqid, String fjlx);

    /**
     * 根据sqid获取附件信息集合
     *
     * @param sqid
     */
    List<GxYyFjxx> getFjxxBySqid(String sqid);

    void updateFjxxShzt(String fjid, String shzt);
    /**
     * 
     * @param sqid
     * @param fjlx
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyFjxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyFjxx> getFjxxBySqidAndFjlxForUpdate(String sqid, String fjlx);
}



