package cn.gtmap.hlw.core.dao.xtts;


import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.xtts.XttsQueryDto;
import cn.gtmap.hlw.core.model.GxYyXtts;

import java.util.List;

/**
 * @author xuehaifeng
 * @version 1.0
 * @date 2024/12/26 14:18
 * @description
 */
public interface GxYyXttsDao {


    /**
     * 查询系统接入表全部数据
     * @return 实例对象集合
     */
    List<GxYyXtts> all();

    /**
     * 通过ID查询单条数据
     *
     * @param uuid 主键
     * @return
     */
    GxYyXtts get(String uuid);


    /**
     * 系统接入表--分页查询
     * @param paramsDTO
     * @return GxYyXtjrPO集合
     */
    PageInfo<GxYyXtts> queryPage(XttsQueryDto paramsDTO);

    /**
     * 删除
     *
     * @param uuid 主键
     * @return 实例对象
     */
    void delete(String uuid);


    /**
     * 保存更新
     * @param gxYyXtts 实例对象
     */
    void saveOrUpdateXtts(GxYyXtts gxYyXtts);

    void updateTzzt(XttsQueryDto xttsQueryDto);
}
