package cn.gtmap.hlw.core.util.encryption.aes;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 *
 * @author shen_feng 加密解密
 */
public class HanAesUtil {

    // static String sKey = "HOPERUN.COM";

    /**
     * 密钥如超过16位，截至16位，不足16位，补/000至16位
     *
     * @param key 原密钥
     * @return 新密钥
     */
    public static String secureBytes(String key) {
        if (key.length() > 16) {
            key = key.substring(0, 16);
        } else if (key.length() < 16) {
            StringBuilder keyBuilder = new StringBuilder(key);
            for (int i = (keyBuilder.length() - 1); i < 15; i++) {
                keyBuilder.append("\000");
            }
            key = keyBuilder.toString();
        }
        return key;
    }

    /**
     * AES解密 用于数据库储存
     *
     * @param sSrc
     * @param key
     * @return
     * @throws Exception
     */
    public static String decryptCode(String sSrc, String key) {

        String sKey = secureBytes(key);

        try {
            // 判断Key是否正确
            if (sKey == null) {
                // LogUtil.d("AesUtil", "Key为空null");
                return null;
            }
            // 判断Key是否为16位
            if (sKey.length() != 16) {
                // LogUtil.d("AesUtil", "Key长度不是16位");
                sKey = secureBytes(sKey);
            }
            byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);
            byte[] encrypted1 = hex2byte(sSrc);
            try {
                byte[] original = cipher.doFinal(encrypted1);
                return new String(original, "GBK");
            } catch (Exception e) {
                return null;
            }
        } catch (Exception ex) {
            return null;
        }

    }

    /**
     * AES解密 用于数据库储存
     *
     * @param sSrc
     * @param key
     * @return
     * @throws Exception
     */
    public static String decrypt(String sSrc, String key) {

        String sKey = secureBytes(key);

        try {
            // 判断Key是否正确
            if (sKey == null) {
                // LogUtil.d("AesUtil", "Key为空null");
                return null;
            }
            // 判断Key是否为16位
            if (sKey.length() != 16) {
                //System.out.println("长度不是16");
                // LogUtil.d("AesUtil", "Key长度不是16位");
                sKey = secureBytes(sKey);
            }
            byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);
            byte[] encrypted1 = hex2byte(sSrc);
            try {
                byte[] original = cipher.doFinal(encrypted1);

                // String originalString = new String(original, "GBK");

                return new String(original, StandardCharsets.UTF_8);
            } catch (Exception e) {
                return null;
            }
        } catch (Exception ex) {
            return null;
        }

    }

    public static String decryptLicense(String sSrc, String key) {
        String sKey = secureBytes(key);
        try {
            // 判断 Key 是否正确
            if (sKey == null) {
                // LogUtil.d("AesUtil", "Key 为空 null");
                return null;
            }
            // 判断 Key 是否为 16 位
            if (sKey.length() != 16) {
//                System.out.println("长度不是 16");
                // LogUtil.d("AesUtil", "Key 长度不是 16 位");
                sKey = secureBytes(sKey);
            }
            byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);
            byte[] encrypted1 = Base64.getDecoder().decode(sSrc.getBytes());
            try {
                byte[] original = cipher.doFinal(encrypted1);
                // String originalString = new String(original,"GBK");
                return new String(original, StandardCharsets.UTF_8);
            } catch (Exception e) {
                return null;
            }
        } catch (Exception ex) {
            return null;
        }
    }
    public static String encrypt4Contacts(String sSrc) {
        return sSrc;
    }

    /**
     * AES加密
     *
     * @param sSrc
     * @param key
     * @return
     * @throws Exception
     */
    public static String encrypt(String sSrc, String key) {

        String sKey = secureBytes(key);
        try {
            if (sSrc == null || sKey == null) {
                // LogUtil.d("AesUtil", "Key为空null");
                return null;
            }
            // 判断Key是否为16位
            if (sKey.length() != 16) {
                // LogUtil.d("AesUtil", "Key长度不是16位");
                sKey = secureBytes(sKey);
            }
            byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes());
            return byte2hex(encrypted).toLowerCase();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return null;
        }
    }

    /**
     * @param strhex
     * @return
     */
    public static byte[] hex2byte(String strhex) {
        if (strhex == null) {
            return null;
        }
        int l = strhex.length();
        if (l % 2 == 1) {
            return null;
        }
        byte[] b = new byte[l / 2];
        for (int i = 0; i != l / 2; i++) {
            b[i] = (byte) Integer.parseInt(strhex.substring(i * 2, i * 2 + 2),
                    16);
        }
        return b;
    }

    /**
     * @param b
     * @return
     */
    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (byte value : b) {
            stmp = (Integer.toHexString(value & 0XFF));
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
            } else {
                hs.append(stmp);
            }
        }
        return hs.toString().toUpperCase();
    }

    public static void main(String[] args) {
        String userinfo ="{\"uuid\":\"用户唯一id\",\"loginname\":\"djjg15\",\"name\":\"韦小军\",\"code\":\"用户编码\",\"cardid\":\"340825199009190438\",\"mobile\":\"18994060923\",\"email\":\"邮箱\",\"isauth\":\"1\",\"authlevel\":\"1\",\"phone\":\"18994060923\",\"areacode\":\"区域编码\",\"nation\":\"民族\",\"regtime\":\"\",\"logintime\":\"\"}";

        try {
            userinfo = HanAesUtil.encrypt(userinfo, "ZAAT9YE1QGif");
            System.out.println(userinfo);
            System.out.println(HanAesUtil.decrypt(userinfo, "ZAAT9YE1QGif"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
