/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption.aes;

import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AesUtil {
    private static Logger logger = LoggerFactory.getLogger(AesUtil.class);

    public static String encryptHh(String sSrc, String key) {
        try {
            String sKey = AesUtil.secureBytes(key);
            if (sKey.length() != 16) {
                sKey = AesUtil.secureBytes(sKey);
            }
            byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes(StandardCharsets.UTF_8));
            return AesUtil.byte2hex(encrypted).toLowerCase();
        }
        catch (Exception e) {
            logger.error("AES\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public static String decryptHh(String sSrc, String key) {
        try {
            String sKey = AesUtil.secureBytes(key);
            if (sKey.length() != 16) {
                sKey = AesUtil.secureBytes(sKey);
            }
            byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeySpec);
            byte[] encrypted1 = AesUtil.hex2byte(sSrc);
            byte[] original = cipher.doFinal(encrypted1);
            return new String(original, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            logger.error("AES\u89e3\u5bc6\u5f02\u5e38\uff1a{}", (Throwable)ex);
            return null;
        }
    }

    public static byte[] hex2byte(String strhex) {
        if (strhex == null) {
            return null;
        }
        int l = strhex.length();
        if (l % 2 == 1) {
            return null;
        }
        byte[] b = new byte[l / 2];
        for (int i = 0; i != l / 2; ++i) {
            b[i] = (byte)Integer.parseInt(strhex.substring(i * 2, i * 2 + 2), 16);
        }
        return b;
    }

    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0" + stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static String secureBytes(String key) {
        if (key.length() > 16) {
            key = key.substring(0, 16);
        } else if (key.length() < 16) {
            StringBuilder keyBuilder = new StringBuilder(key);
            for (int i = keyBuilder.length() - 1; i < 15; ++i) {
                keyBuilder.append("\u0000");
            }
            key = keyBuilder.toString();
        }
        return key;
    }

    public static String encrypt(String sSrc, String keyStr) {
        try {
            byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            logger.error("AesUtil\u7c7bencrypt\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public static String encryptNull(String sSrc, String keyStr) {
        if (StringUtils.isBlank((CharSequence)sSrc) || StringUtils.isBlank((CharSequence)keyStr)) {
            return null;
        }
        return AesUtil.encrypt(sSrc, keyStr);
    }

    public static String decrypt(String sSrc, String keyStr) {
        try {
            if (StringUtils.isNotBlank((CharSequence)sSrc)) {
                byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
                SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, skeySpec);
                byte[] encrypted = Base64.decodeBase64((String)sSrc);
                byte[] original = cipher.doFinal(encrypted);
                return new String(original, StandardCharsets.UTF_8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String decryptNull(String sSrc, String keyStr) {
        String result = sSrc;
        if (StringUtils.isNotBlank((CharSequence)sSrc) && StringUtils.isNotBlank((CharSequence)keyStr) && StringUtils.isBlank((CharSequence)(result = AesUtil.decrypt(sSrc, keyStr)))) {
            result = sSrc;
        }
        return result;
    }

    public static String decryptByPage(String key, String value) {
        return AesUtil.decrypt(key, key, key, value);
    }

    public static String decrypt(String salt, String iv, String passphrase, String ciphertext) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKey key = AesUtil.generateKey(salt, passphrase);
            byte[] decrypted = AesUtil.doFinal(2, key, iv, AesUtil.base64(ciphertext), cipher);
            if (decrypted != null) {
                return new String(decrypted, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            logger.error("AesUtil\u7c7bdecrypt\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return null;
    }

    private static SecretKey generateKey(String salt, String passphrase) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), AesUtil.hex(salt), 1000, 128);
            return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    private static byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes, Cipher cipher) {
        try {
            cipher.init(encryptMode, (Key)key, new IvParameterSpec(AesUtil.hex(iv)));
            return cipher.doFinal(bytes);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static byte[] hex(String str) {
        try {
            return Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] base64(String str) {
        return Base64.decodeBase64((String)str);
    }

    public static String decryptByCbc(String content, String key) {
        String result = null;
        try {
            byte[] keyByte = key.getBytes(StandardCharsets.UTF_8);
            byte[] contentByte = content.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyByte, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(keyByte);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] resultByte = cipher.doFinal(contentByte);
            if (resultByte != null && resultByte.length > 0) {
                result = new String(resultByte, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return result;
    }

    private static byte[] generalKey(String keyStr) {
        byte[] bytes = new byte[]{};
        MessageDigest md = null;
        try {
            bytes = keyStr.getBytes(StandardCharsets.UTF_8);
            md = MessageDigest.getInstance("SHA-256");
            md.update(bytes);
            return md.digest();
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    private static byte[] generalIv(String keyStr) {
        byte[] bytes = new byte[]{};
        MessageDigest md = null;
        try {
            bytes = keyStr.getBytes(StandardCharsets.UTF_8);
            md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            return md.digest();
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String getRandomKey() {
        String key = "";
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey sk = keyGenerator.generateKey();
            byte[] b = sk.getEncoded();
            key = AesUtil.byteToHexString(b);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return key;
    }

    public static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String strHex = Integer.toHexString(bytes[i]);
            if (strHex.length() > 3) {
                sb.append(strHex.substring(6));
                continue;
            }
            if (strHex.length() < 2) {
                sb.append("0" + strHex);
                continue;
            }
            sb.append(strHex);
        }
        return sb.toString();
    }

    public static String generateParamStr(Map<String, String> params) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (String key : params.keySet()) {
            if ("mac".equals(key)) continue;
            String val = params.get(key);
            paramList.add(key + "=" + val);
        }
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(paramList)) {
            Collections.sort(paramList);
            sb.append((String)paramList.get(0));
            for (int i = 1; i < paramList.size(); ++i) {
                sb.append("&").append((String)paramList.get(i));
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PrivateKey readPrivateKey(String strPfx, String strPassword) {
        try (FileInputStream fis = new FileInputStream(strPfx);){
            KeyStore ks = KeyStore.getInstance("PKCS12");
            char[] nPassword = null;
            nPassword = strPassword == null || "".equals(strPassword.trim()) ? null : strPassword.toCharArray();
            ks.load(fis, nPassword);
            fis.close();
            Enumeration<String> enumas = ks.aliases();
            String keyAlias = null;
            if (enumas.hasMoreElements()) {
                keyAlias = enumas.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)ks.getKey(keyAlias, nPassword);
            return privateKey;
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String decryptHh(byte[] sSrc, String key) {
        try {
            String sKey = AesUtil.secureBytes(key);
            if (StringUtils.isNotEmpty((CharSequence)sKey)) {
                if (sKey.length() != 16) {
                    sKey = AesUtil.secureBytes(sKey);
                }
                byte[] raw = sKey.getBytes(StandardCharsets.US_ASCII);
                SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, skeySpec);
                byte[] original = cipher.doFinal(sSrc);
                return new String(original, StandardCharsets.UTF_8);
            }
        }
        catch (Exception ex) {
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        return "";
    }
}

