package cn.gtmap.hlw.core.util.encryption.md5;

import cn.gtmap.hlw.core.constant.number.NumberConstant;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

/**
 * @author admin
 * @version V1.0
 * @Date 2023/6/7
 * @description MD5签名
 */
public class Md5 {

    private static Logger logger = LoggerFactory.getLogger(Md5.class);

    static final char[] HEX_DIGITS = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    /**
     * MD5加密盐值
     */
    public static final String MD5_SALT = "gtis";

    /**
     * 签名字符串
     *
     * @param text         需要签名的字符串
     * @param key          密钥
     * @param inputCharset 编码格式
     * @return 签名结果
     */
    public static String sign(String text, String key, String inputCharset) {
        if (StringUtils.isNotBlank(text)) {
            if (StringUtils.isBlank(inputCharset)) {
                inputCharset = String.valueOf(StandardCharsets.UTF_8);
            }
            if (StringUtils.isNotBlank(key)) {
                text = text + key;
            }
            return DigestUtils.md5Hex(getContentBytes(text, inputCharset));
        }
        return null;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description md5加密，不要key
     **/
    public static String signNoKey(String text, String inputCharset) {
        if (StringUtils.isNotBlank(text)) {
            if (StringUtils.isBlank(inputCharset)) {
                inputCharset = String.valueOf(StandardCharsets.UTF_8);
            }
            return DigestUtils.md5Hex(getContentBytes(text, inputCharset));
        }
        return null;
    }

    /**
     * 签名字符串
     *
     * @param text         需要签名的字符串
     * @param sign         签名结果
     * @param key          密钥
     * @param inputCharset 编码格式
     * @return 签名结果
     */
    public static boolean verify(String text, String sign, String key, String inputCharset) {
        text = text + key;
        String mysign = DigestUtils.md5Hex(getContentBytes(text, inputCharset));
        return mysign.equals(sign);
    }

    /**
     * @param content
     * @param charset
     * @return
     * @throws java.security.SignatureException
     * @throws UnsupportedEncodingException
     */
    private static byte[] getContentBytes(String content, String charset) {
        try {
            if (charset == null || charset.isEmpty()) {
                return content.getBytes(StandardCharsets.UTF_8);
            }
            return content.getBytes(charset);
        } catch (UnsupportedEncodingException e) {
            logger.error("MD5签名过程中出现错误,指定的编码集不对,您目前指定的编码集是:" + charset, e);
        }
        return null;
    }

    /**
     * 描述：MD5加密.
     *
     * @param str 要加密的字符串
     * @return String 加密的字符串
     */
    public static String md5Sign(String str) {
        try {
            byte[] strTemp = str.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            // MD5 的计算结果是一个 128 位的长整数，
            byte[] tmp = mdTemp.digest();
            // 用字节表示就是16 个字节 : 每个字节用 16 进制表示的话，使用两个字符，
            char[] strs = new char[16 * 2];
            // 所以表示成 16 进制需要 32 个字符 : k表示转换结果中对应的字符位置
            int k = 0;
            for (int i = 0; i < NumberConstant.INT_SIXTEEN; i++) {
                // 从第一个字节开始，对 MD5 的每一个字节转换成 16 进制字符的转换
                // 取第 i 个字节
                byte byte0 = tmp[i];
                // 取字节中高 4 位的数字转换,
                strs[k++] = HEX_DIGITS[byte0 >>> 4 & 0xf];
                // >>> 为逻辑右移，将符号位一起右移 :取字节中低 4 位的数字转换
                strs[k++] = HEX_DIGITS[byte0 & 0xf];
            }
            // 换后的结果转换为字符串
            return new String(strs).toUpperCase();
        } catch (Exception e) {
            return null;
        }
    }
}