package cn.gtmap.hlw.core.base;

import cn.gtmap.hlw.core.constant.Constants;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/3
 * @description
 */
public class Condition {

    /**
     * 转化成mybatis plus中的Page
     *
     * @param basePage 查询条件
     * @return IPage
     */
    public static <T> IPage<T> getPage(BasePage basePage) {
        final Page<T> page = new Page<>(basePage.getPageNum(), basePage.getPageSize());
        if (StringUtils.equals(Constants.ORDER_DESC, basePage.getSord())) {
            page.addOrder(OrderItem.desc(basePage.getSidx()));
        } else {
            page.addOrder(OrderItem.asc(basePage.getSidx()));
        }
        return page;
    }
}
