package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.dto.yyxx.YyxxKyyrsQueryDTO;
import cn.gtmap.hlw.core.model.GxYyYyxx;
import cn.gtmap.hlw.core.model.query.yyxx.GxYyYyxxQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.Date;
import java.util.List;

/**
 * 预约信息(GxYyYyxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:51
 */
public interface GxYyYyxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param yyh 主键
     * @return 实例对象
     */
    GxYyYyxx get(String yyh);

    /**
     * 通过slbh查询数据集合
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYyYyxx> list(String slbh);
    /**
     * 查询
     *
     * @param queryDTO
     * @return 实例对象
     */
    List<GxYyYyxx> queryYyxxList(YyxxKyyrsQueryDTO queryDTO);

    /**
     * 新增数据
     *
     * @param gxYyYyxx 实例对象
     * @return 影响行数
     */
    void save(GxYyYyxx gxYyYyxx);

    /**
     * 修改数据
     *
     * @param gxYyYyxx 实例对象
     * @return 影响行数
     */
    void update(GxYyYyxx gxYyYyxx);

    /**
     * 新增或修改数据
     *
     * @param gxYyYyxx 实例对象
     * @return 影响行数
     */
    String saveOrUpdate(GxYyYyxx gxYyYyxx);
    /**
     * 分页查询
     * @param yyxxQuery
     * @return:IPage<GxYyYyxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    IPage<GxYyYyxx> page(GxYyYyxxQuery yyxxQuery);
    /**
     * 获取最大顺序号
     * @param yysj
     * @param yysd
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    String getSortNum(Date yysj, String yysd);

    /**
     * 根据创建时间获取预约信息数量
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param userId 用户id
     * @return:String
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    Integer getYyxxNumByCreateDate(Date kssj, Date jssj, String userId);

    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    ///void delete(String slbh);
}

