package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyProcessLysjRel;

import java.util.List;

/**
 * 工作流节点与领域事件关系表(GxYyProcessLysjRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:39:57
 */
public interface GxYyProcessLysjRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param plid 主键
     * @return 实例对象
     */
    GxYyProcessLysjRel get(String plid);

    /**
     * 通过processId查询单条数据
     *
     * @param processId
     * @return 实例对象
     */
    List<GxYyProcessLysjRel> getByProcessId(String processId);

    /**
     * 新增数据
     *
     * @param gxYyProcessLysjRel 实例对象
     * @return 影响行数
     */
    void save(GxYyProcessLysjRel gxYyProcessLysjRel);

    /**
     * 修改数据
     *
     * @param gxYyProcessLysjRel 实例对象
     * @return 影响行数
     */
    void update(GxYyProcessLysjRel gxYyProcessLysjRel);

    /**
     * 批量更新
     *
     * @param gxYyProcessLysjRelList 实例对象集合
     */
    void updateBatch(List<GxYyProcessLysjRel> gxYyProcessLysjRelList);


    /**
     * 删除数据
     *
     * @param processId 步骤id
     * @return 影响行数
     */
    void delete(String processId);

    /**
     * 删除数据集合
     *
     * @param plidList 主键集合
     * @return 影响行数
     */
    void deleteBatch(List<String> plidList);

    /**
     * 领域事件里得公共动作
     *
     * @param lysjdm
     * @param processId
     * @return GxYyProcessLysjRel
     */
    GxYyProcessLysjRel getByLysjdm(String lysjdm, String processId);

    /**
     * 领域事件里得公共动作
     *
     * @param lysjdm
     * @param processId
     * @param anid
     * @return GxYyProcessLysjRel
     */
    GxYyProcessLysjRel getByLysjdm(String lysjdm, String processId,String anid);

    /**
     * 批量获取领域事件
     * @param processIds
     * @return
     */
    List<GxYyProcessLysjRel> getByProcessIds(List<String> processIds);

    /**
     * 通过processId和按钮id获取集合数据
     * @param processId
     * @param anid
     * @return List<GxYyProcessLysjRel>
     */
    List<GxYyProcessLysjRel> getByProcessIdAndAnid(String processId, String anid);

    /**
     * 批量更新或保存
     * @param lysjRelList
     */
    void saveOrUpdateBatch(List<GxYyProcessLysjRel> lysjRelList);

    /**
     * 根据id删除
     *
     * @param plid
     */
    void deleteById(String plid);

    /**
     * 通过lyshdm和sqlx获取集合数据
     *
     * @param lysjdm 领域事件代码
     * @param sqlx   申请类型
     * @return List<GxYyProcessLysjRel>
     */
    GxYyProcessLysjRel getByLysjdmAndSqlx(String lysjdm, String sqlx);

    /**
     * 通过lyshdm和sqlx获取集合数据
     *
     * @param lysjdm 领域事件代码
     * @param sqlx   申请类型
     * @return List<GxYyProcessLysjRel>
     */
    List<GxYyProcessLysjRel> getListByLysjdmAndSqlx(String lysjdm, String sqlx);

    /**
     * 通过lyshdm模糊和sqlx获取集合数据
     *
     * @param lysjdm 领域事件代码
     * @param sqlx   申请类型
     * @return List<GxYyProcessLysjRel>
     */
    List<GxYyProcessLysjRel> getListByLysjdmLikeAndSqlx(String lysjdm, String sqlx);

    List<GxYyProcessLysjRel> getListByLysjdmLikeAndQlrlxQAndSqlx(String lysjdm, String sqlx, String qlrlx);
}

