package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description 接口出入参-加解密-工具类
 */
@Slf4j
public class ApiSecurityUtils {

    /**
     * @param sm4KeyBySm2 经过Sm2加密的sm4key
     * @param decryptStr  经过sm4加密的数据
     * @return 解密后的数据
     */
    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    /**
     * @param encryptStr     要加密的数据
     * @param frontPublicKey 前端公钥
     * @return 加密后的数据
     */
    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey)  {
        //生成一个随机的sm4加密key
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        //加密
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        //用前端公钥(用前端的公钥)，sm2加密sm4Key
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    //加解密测试
    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";

        //前端入参 解密
        String dataEncrypt = "915f4978a6b770719e05cccaedc65e0bd4a6c1c3a5fdf1e8285359d404390b568f12838e65dbc9664c6516ec20ee6a7c367cc6664161de32062a0774fe2c256265126686c60b28ee929fd08a3a658187733969e357e463d4dba852f9d3964e7d94d078dca284746c2a0a2ed594d5dd5fdf59a1e406a4681f490ad86891da570b990de69c342957375d67055d818149401219df5a08bf5799c0e2c662d055fcbabf06cfc8e4e7e4d1259d9afefe091dda4fc0f99c86d5b440d30e4bc924d1d79025f72995fe3160676b5b4d6bc824b2a7624d9527f22d2e90c19c37d97797a60e8ee4c7bc9352c7f129d94946954fb904a93ee2bb6c52961f0a6035c498c08f0fd84f2b51974e822f215ac7e2485d816225fa6f077d7db332fe1c1c22c4dee283549ca115d81df0d47e6059bef5a483466bea67547b110484bf6f94f9c3e5e2e2";
        String paramid = "04e8d25a1012e4b8abff45b06576adbabddc42537f27c4adcdf97da2ba6bbb6438bdad6c9b50e6bc96a1693eec1794627669384ad5c845c89d5ceb214e154b77963c7b887f3b31c33c08f7bf00d7b30168747b65c9ddce5ce17327f8f0bfbb63fca794c0f0cf3a70c4e5f2dc39ee32e4dbe3e6c6355e8e4e2e28656a053f93a08283b3b3a076e108cc62569aba";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
//
//        //生成前端加密密文
//        //生成一个随机的sm4加密key
//        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
//        //前端入参
//        String encryptStr = "{\"slbh\":\"W202503190079\",\"processId\":\"b912481754e64dfea519b07745f68dc7\",\"anid\":\"\"}";
//        //加密
//        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
//        String paramid2 = Sm2lib.encode(sm4Key);
//
//        ApiEncryptBody body = new ApiEncryptBody();
//        body.setData(data);
//        body.setParamid(paramid2);
//        body.setFrontKey(pubKey);
//
//        System.out.println(JSON.toJSONString(body));
    }

}
