package cn.gtmap.hlw.core.constant.lysj;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/13 15:10
 * @description 领域事件常量
 */
public class LysjConstant {

    //领域事件类型
    /**
     * 工作流事件
     */
    public static final String LYSJLX_WORKFLOW = "work.flow";
    /**
     * 预约事件
     */
    public static final String LYSJLX_YYXX = "yyxx";
    /**
     * 登录事件
     */
    public static final String LYSJLX_LOGIN = "login";
    /**
     * 流程申请
     */
    public static final String LYSJLX_SQXX = "sqxx";

    //登录事件
    /**
     * 个人登录领域事件
     */
    public static final String LYSJDM_LOGIN_PERSON = "lysjdm.login.person";

    //登录事件
    /**
     * 个人注册并登录领域事件
     */
    public static final String LYSJDM_REGIST_AND_LOGIN_PERSON = "lysjdm.regist.and.login.person";
    /**
     * 企业登录领域事件
     */
    public static final String LYSJDM_LOGIN_ORGANIZE = "lysjdm.login.organize";
    /**
     * 第三方接口登录领域事件
     */
    public static final String LYSJDM_LOGIN_INTERFACE = "lysjdm.login.interface";
    /**
     * 登记机构/管理员登录领域事件
     */
    public static final String LYSJDM_LOGIN_DJJG = "lysjdm.login.djjg";

    /**
     * 管理员登录领域事件
     */
    public static final String LYSJDM_LOGIN_GLY = "lysjdm.login.gly";

    /**
     * 单点登录领域事件
     */
    public static final String LYSJDM_LOGIN_SSO = "lysjdm.login.sso";
    /**
     * 个人注册领域事件
     */
    public static final String LYSJDM_REGISTER_PERSON = "lysjdm.register.person";

    //工作流事件
    /**
     * 工作流初始化事件
     */
    public static final String LYSJDM_WORKFLOW_INIT = "lysjdm.workflow.init";

    /**
     * 工作流查询
     */
    public static final String LYSJDM_WORKFLOW_QUERY = "lysjdm.workflow.query";
    /**
     * 流程申请
     */
    public static final String LYSJDM_SQXX_SAVEORUPDATE = "lysjdm.sqxx.saveOrUpdate";
    /**
     * 流程申请保存（批量）
     */
    public static final String LYSJDM_SQXX_BATCH_SAVEORUPDATE = "lysjdm.sqxx.batch.saveOrUpdate";
    /**
     * 流程申请删除
     */
    public static final String LYSJDM_SQXX_DELETE = "lysjdm.sqxx.delete";
    /**
     * 推送登记系统 申请信息+附件
     */
    public static final String LYSJDM_SQXX_PUSH_DJ = "lysjdm.sqxx.push.dj";
    /**
     * 推送登记系统 申请信息+抵押首次
     */
    public static final String LYSJDM_SQXX_PUSH_DJ_DYSC = "lysjdm.sqxx.push.dj.dysc";
    /**
     * 推送登记系统 申请信息+抵押注销
     */
    public static final String LYSJDM_SQXX_PUSH_DJ_DYZX = "lysjdm.sqxx.push.dj.dyzx";
    /**
     * 推送登记系统--附件
     */
    public static final String LYSJDM_SQXX_PUSH_DJ_FJ = "lysjdm.sqxx.push.dj.fj";
    /**
     * 推送登记系统--退件申请
     */
    public static final String LYSJDM_SQXX_PUSH_DJ_TJSQ = "lysjdm.sqxx.push.dj.tjsq";
    /**
     * 推送登簿
     */
    public static final String LYSJDM_SQXX_PUSH_DB = "lysjdm.sqxx.push.db";
    /**
     * 流程申请提交事件
     */
    public static final String LYSJDM_SQXX_COMMIT = "lysjdm.sqxx.commit";
    /**
     * 流程申请更新事件
     */
    public static final String LYSJDM_SQXX_SLZT_UPDATE = "lysjdm.sqxx.slzt.update";
    /**
     * 银行直连更新受理状态
     */
    public static final String LYSJDM_SQXX_SLZT_YHZL_UPDATE = "lysjdm.sqxx.slzt.yhzl.update";
    /**
     * 银行直连查询受理状态
     */
    public static final String LYSJDM_SQXX_SLZT_YHZL_QUERY = "lysjdm.sqxx.slzt.yhzl.query";
    /**
     * 流程申请审核
     */
    public static final String LYSJDM_SQXX_AUDIT = "lysjdm.sqxx.audit";

    //办件授权
    /**
     * 发起/保存授权
     */
    public static final String LYSJDM_SQXX_CQBJSQ_SAVE = "lysjdm.sqxx.cqbjsq.save";
    /**
     * 查询授权结果
     */
    public static final String LYSJDM_SQXX_CQBJSQ_QUERY = "lysjdm.sqxx.cqbjsq.query";
    /**
     * 查询授权结果（芜湖开发商）
     */
    public static final String LYSJDM_SQXX_KFSSQ_QUERY = "lysjdm.sqxx.kfssq.query";
    /**
     * 保存授权（芜湖开发商）
     */
    public static final String LYSJDM_SQXX_KFSSQ_SAVE = "lysjdm.sqxx.kfssq.save";

    //生成pdf文件
    /**
     * 生成 产权办件申请pdf
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_CQBJSQ = "lysjdm.sqxx.generate.pdf.cqbjsq";

    /**
     * 提交事件生成pdf文件
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_COMMIT = "lysjdm.sqxx.generate.pdf.commit";

    /**
     * 附件预览
     */
    public static final String LYSJDM_SQXX_GENERATE_FJ_PREVIEW = "lysjdm.sqxx.generate.fj.preview";

    /**
     * 通用sql打印事件
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_BYSQL = "lysjdm.sqxx.generate.pdf.bysql";

    /**
     * 通用sql打印登记资料查询附件事件
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_DJZLCX_BYSQL = "lysjdm.sqxx.generate.pdf.djzlcx.bysql";

    /**
     * 收件单打印事件（通过sql打印）
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_SJD_BYSQL = "lysjdm.sqxx.generate.pdf.sjd.bysql";

    /**
     * 抵押收件单打印事件（通过sql打印）
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_DYSJD_BYSQL = "lysjdm.sqxx.generate.pdf.dysjd.bysql";

    /**
     * 生成待打印的pdf
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINT = "lysjdm.sqxx.generate.pdf.print";

    /**
     * 生成待打印的pdf--收件单
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTSJD = "lysjdm.sqxx.generate.pdf.printsjd";
    /**
     * 生成待打印的pdf--移交单
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTYJD = "lysjdm.sqxx.generate.pdf.printyjd";
    /**
     * 生成待打印的pdf--抵押注销证明
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTDYZX = "lysjdm.sqxx.generate.pdf.printdyzxzm";
    /**
     * 生成待打印的pdf--抵押注销申请书
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTDYZXSQS = "lysjdm.sqxx.generate.pdf.printdyzxsqs";
    /**
     * 生成待打印的pdf--产权查询
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTCQCX = "lysjdm.sqxx.generate.pdf.printCqcx";
    /**
     * 生成待打印的pdf--抵押查询
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTDYCX = "lysjdm.sqxx.generate.pdf.printDycx";
    /**
     * 生成待打印的pdf--登记簿
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTDJB = "lysjdm.sqxx.generate.pdf.printDjb";
    /**
     * 生成待打印的pdf--无房证明
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTWFZM = "lysjdm.sqxx.generate.pdf.printWfzm";

    /**
     * 生成待打印的pdf--房屋信息证明
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTFWXXZM = "lysjdm.sqxx.generate.pdf.printFwxxZm";
    /**
     * 生成待打印的pdf--房查证明
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTFCZM = "lysjdm.sqxx.generate.pdf.printFczm";
    /**
     * 生成待打印的pdf--主债权合同
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTZZQHT = "lysjdm.sqxx.generate.pdf.printZzqht";
    /**
     * 生成待打印的pdf--审批表
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTSPB = "lysjdm.sqxx.generate.pdf.printSpb";
    /**
     * 生成待打印的pdf--住房历史信息
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTZFLSXX = "lysjdm.sqxx.generate.pdf.printZfLsxx";
    /**
     * 生成待打印的pdf--自然状况登记簿
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTZRZKDJB = "lysjdm.sqxx.generate.pdf.printZrzkdjb";
    /**
     * 生成待打印的pdf--贷前然状况登记簿
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTDQZRZKDJB = "lysjdm.sqxx.generate.pdf.printDqZrzkdjb";
    /**
     * 生成待打印的pdf--贷后查询登记簿
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTDDHCXDJB = "lysjdm.sqxx.generate.pdf.printDhcxdjb";
    /**
     * 生成待打印的pdf--授权查询委托书
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTSQCXWTS = "lysjdm.sqxx.generate.pdf.printSqcxwts";
    /**
     * 生成待打印的pdf--房产查询承诺书
     */
    public static final String LYSJDM_SQXX_GENERATE_PDF_PRINTFCCXCNS = "lysjdm.sqxx.generate.pdf.printFccxCns";
    /**
     * 问询笔录初始化事件
     */
    public static final String LYSJDM_SQXX_WXBL_INIT = "lysjdm.sqxx.wxbl.init";
    /**
     * 问询笔录保存或更新事件
     */
    public static final String LYSJDM_SQXX_WXBL_SAVEORUPDATE = "lysjdm.sqxx.wxbl.saveOrUpdate";


    //合同事件
    /**
     * 第三方合同信息获取
     */
    public static final String LYSJDM_THIRD_BAHTXX = "lysjdm.third.bahtxx";

    //合同事件
    /**
     * 第三方合同信息获取批量
     */
    public static final String LYSJDM_THIRD_BAHTXX_PL = "lysjdm.third.bahtxx.pl";

    //合同事件
    /**
     * 第三方合同状态信息获取
     */
    public static final String LYSJDM_THIRD_BAHTZTXX = "lysjdm.third.bahtztxx";

    /**
     * 合同保存或更新事件
     */
    public static final String LYSJDM_SQXX_HTXX_SAVEORUPDATE = "lysjdm.sqxx.htxx.saveOrUpdate";

    /**
     * 产权保存事件
     */
    public static final String LYSJDM_SQXX_CQXX_SAVEORUPDATE = "lysjdm.sqxx.cqxx.saveOrUpdate";
    /**
     * 产权批量保存事件
     */
    public static final String LYSJDM_SQXX_CQXX_BATCH_SAVEORUPDATE = "lysjdm.sqxx.cqxx.batch.saveOrUpdate";
    /**
     * 不动产证明查询
     */
    public static final String LYSJDM_THIRD_BDCZM_QUERY = "lysjdm.third.bdczm.query";
    /**
     * 不动产证明查询(多人)
     */
    public static final String LYSJDM_THIRD_BDCZM_DR_QUERY = "lysjdm.third.bdczm.dr.query";
    /**
     * 不动产证明保存
     */
    public static final String LYSJDM_THIRD_BDCZM_SAVEORUPDATE = "lysjdm.third.bdczm.saveOrUpdate";
    /**
     * 批量不动产证明保存
     */
    public static final String LYSJDM_THIRD_BDCZM_BATCH_SAVEORUPDATE = "lysjdm.third.bdczm.batch.saveOrUpdate";
    /**
     * 通过第三方接口更新信息
     */
    public static final String LYSJDM_THIRD_API_UPDATE = "lysjdm.third.api.update";
    /**
     * 产权证抵押信息查询
     */
    public static final String LYSJDM_THIRD_CQZDYXX_QUERY = "lysjdm.third.cqzdyxx.query";

    /**
     * 限制信息校验
     */
    public static final String LYSJDM_SQXX_XZXX_CHECK = "lysjdm.sqxx.xzxx.check";


    /**
     * 限制信息校验
     */
    public static final String LYSJDM_SQXX_XZXX_CHECK_YHZL = "lysjdm.sqxx.xzxx.check.yhzl";

    /**
     * 提交限制信息校验银行直连
     */
    public static final String LYSJDM_SQXX_COMMIT_XZXX_CHECK = "lysjdm.sqxx.commit.xzxx.check";

    /**
     * 限制信息校验--批量
     */
    public static final String LYSJDM_SQXX_XZXX_PL_CHECK = "lysjdm.sqxx.xzxx.pl.check";

    //权利人
    /**
     * 删除权利人
     */
    public static final String LYSJDM_SQXX_DELETE_QLR = "lysjdm.sqxx.delete.qlr";
    /**
     * 权利人会签
     */
    public static final String LYSJDM_SQXX_QLR_HQ = "lysjdm.sqxx.qlr.hq";

    /**
     * 抵押权人
     */
    public static final String LYSJDM_SQXX_DYQR_HQ = "lysjdm.sqxx.dyqr.hq";

    //附件
    /**
     * 附件上传事件
     */
    public static final String LYSJDM_FJ_UPLOAD = "lysjdm.fj.upload";
    /**
     * 仅是上传附件至第三方事件
     */
    public static final String LYSJDM_FJ_ONLY_UPLOAD_TO_THIRD = "lysjdm.fj.only.upload.to.third";
    /**
     * 附件上传事件
     */
    public static final String LYSJDM_FJ_UPLOAD_BY_FJID = "lysjdm.fj.upload.by.fjid";
    /**
     * 第三方附件上传事件
     */
    public static final String LYSJDM_THIRD_FJ_UPLOAD = "lysjdm.third.fj.upload";
    /**
     * 第三方附件下载事件
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD = "lysjdm.third.fj.download";
    /**
     * 第三方附件下载校验事件
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_CHECK = "lysjdm.third.fj.download.check";
    /**
     * 第三方附件下载事件-登记
     */
    public static final String LYSJDM_THIRD_DJ_FJ_DOWNLOAD = "lysjdm.third.dj.fj.download";
    /**
     * 第三方附件下载事件-宗地图
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_ZDT = "lysjdm.third.fj.download.zdt";
    /**
     * 第三方附件下载事件-户室图
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_HST = "lysjdm.third.fj.download.hst";
    /**
     * 第三方附件下载事件-房屋套次
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_FWTC = "lysjdm.third.fj.download.fwtc";

    /**
     * 第三方附件下载事件-未成年房屋套次
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_WCNFWTC = "lysjdm.third.fj.download.wcnfwtc";
    /**
     * 第三方附件下载事件-档案信息
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_DAXX = "lysjdm.third.fj.download.daxx";
    /**
     * 第三方附件下载事件-坐落下载登记簿
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_DJB_BYZL = "lysjdm.third.fj.download.djb.byzl";
    /**
     * 第三方附件下载事件-下载电子证照
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_DZZZ = "lysjdm.third.fj.download.dzzz";
    /**
     * 第三方附件下载事件-居民身份证下载电子证照
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_JMSFZ = "lysjdm.third.fj.download.jmsfz";
    /**
     * 第三方附件下载事件-电子证照抵押附表
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_DZZZ_DYFB = "lysjdm.third.fj.download.dzzz.dyfb";
    /**
     * 第三方附件下载事件-电子证照抵押申请单
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_DZZZ_DYSQD = "lysjdm.third.fj.download.dzzz.dysqd";
    /**
     * 第三方附件下载事件-芜湖电子缴款书
     */
    public static final String LYSJDM_THIRD_FJ_DOWNLOAD_WH_DZJKS = "lysjdm.third.fj.download.wh.dzjks";

    /**
     * 根据FJID删除附件
     */
    public static final String LYSJDM_FJ_DELETE_BY_FJID = "lysjdm.fj.delete.by.fjid";
    /**
     * 根据slbh删除附件
     */
    public static final String LYSJDM_FJ_DELETE_BY_SLBH = "lysjdm.fj.delete.by.slbh";
    /**
     * 根据附件来源删除附件
     */
    public static final String LYSJDM_FJ_DELETE_BY_FJLY = "lysjdm.fj.delete.by.fjly";
    /**
     * 根据附件类型删除附件
     */
    public static final String LYSJDM_FJ_DELETE_BY_FJLX = "lysjdm.fj.delete.by.fjlx";
    /**
     * 根据FJID查看附件
     */
    public static final String LYSJDM_FJ_VIEW_BY_FJID = "lysjdm.fj.view.by.fjid";
    /**
     * 根据FJID下载附件
     */
    public static final String LYSJDM_FJ_DOWNLOAD_BY_FJID = "lysjdm.fj.download.by.fjid";
    /**
     * 根据FJID下载附件--提供给第三方
     */
    public static final String LYSJDM_FJ_DOWNLOAD_FOR_THIRD = "lysjdm.fj.download.for.third";
    /**
     * 根据第三方url下载附件
     */
    public static final String LYSJDM_FJ_DOWNLOAD_FOR_URL = "lysjdm.fj.download.for.url";
    /**
     * 获取附件下载票据id
     */
    public static final String LYSJDM_FJ_DOWNLOAD_TICKET = "lysjdm.fj.download.ticket";
    /**
     * 附件目录初始化事件
     */
    public static final String LYSJDM_FJXM_INIT = "lysjdm.fjxm.init";

    /**
     * 附件目录查询事件
     */
    public static final String LYSJDM_FJXM_FJFL_QUERY = "lysjdm.fjxm.fjfl.query";

    /**
     * 附件项目查询事件
     */
    public static final String LYSJDM_FJXM_QUERY = "lysjdm.fjxm.query";


    //字典查询
    /**
     * 登记原因查询
     */
    public static final String LYSJDM_DICT_DJYY_QUERY = "lysjdm.dict.djyy.query";

    /**
     * 登记中心
     */
    public static final String LYSJDM_DJZX_QUERY = "lysjdm.djzx.query";


    //台账
    /**
     * 中介--草稿台账
     */
    public static final String LYSJDM_TZ_AGENCY_DRAFT = "lysjdm.tz.agency.draft";


    //短信
    /**
     * 登录短信事件类型
     */
    public static final String LYSJDM_SMS_YZM_DL = "lysjdm.sms.yzm.dl";

    /**
     * 注册短信事件类型
     */
    public static final String LYSJDM_SMS_YZM_ZC = "lysjdm.sms.yzm.zc";

    /**
     * 验证码事件类型
     */
    public static final String LYSJDM_SMS_YZM = "lysjdm.sms.yzm";

    /**
     * 发送短信事件类型
     */
    public static final String LYSJDM_SMS_SEND = "lysjdm.sms.send";

    //云签
    /**
     * 发起产权办件申请云签
     */
    public static final String LYSJDM_SIGN_CREATE_CQBJSQ = "lysjdm.sign.create.cqbjsq";
    //云签
    /**
     * 发起会签云签
     */
    public static final String LYSJDM_SIGN_CREATE_HQ = "lysjdm.sign.create.hq";

    /**
     * 发起交易合同云签
     */
    public static final String LYSJDM_SIGN_CREATE_JYHT = "lysjdm.sign.create.jyht";

    /**
     * 发起申报单云签
     */
    public static final String LYSJDM_SIGN_CREATE_SBD = "lysjdm.sign.create.sbd";

    /**
     * 发起抵押合同云签
     */
    public static final String LYSJDM_SIGN_CREATE_DYHT = "lysjdm.sign.create.dyht";

    /**
     * 发起税务价格明细单云签
     */
    public static final String LYSJDM_SIGN_CREATE_SWJGMXD = "lysjdm.sign.create.swjgmxd";

    /**
     * 发起批量云签
     */
    public static final String LYSJDM_SIGN_MUL_CREATE_HQ = "lysjdm.sign.mul.create.hq";

    /**
     * 发起静默签章
     */
    public static final String LYSJDM_SILENT_SIGN_CREATE = "lysjdm.silent.sign.create";

    /**
     * 发起静默签章(东方农商行)
     */
    public static final String LYSJDM_SILENT_SIGN_DFNSH_CREATE = "lysjdm.silent.sign.dfnsh.create";

    /**
     * 发起流程外 静默签章
     */
    public static final String LYSJDM_LCW_SILENT_SIGN_CREATE = "lysjdm.lcw.silent.sign.create";

    /**
     * 签字相关操作校验
     */
    public static final String LYSJDM_SIGN_CHECK = "lysjdm.sign.check";

    /**
     * 查询云签签署结果
     */
    public static final String LYSJDM_SIGN_QUERY = "lysjdm.sign.query";

    /**
     * 下载云签附件
     */
    public static final String LYSJDM_SIGN_DOWNLOAD = "lysjdm.sign.download";

    /**
     * 云签结果通知
     */
    public static final String LYSJDM_SIGN_NOTICE = "lysjdm.sign.notice";

    /**
     * 台账发起云签
     */
    public static final String LYSJDM_SIGN_CREATE_TZ = "lysjdm.sign.create.tz";

    /**
     * 登记资料查询发起云签
     */
    public static final String LYSJDM_SIGN_CREATE_DJZLCX = "lysjdm.sign.create.djzlcx";

    /**
     * 银行预审台账发起云签
     */
    public static final String LYSJDM_SIGN_CREATE_YHYSTZ = "lysjdm.sign.create.yhystz";

    /**
     * 生成云签信息
     */
    public static final String LYSJDM_SIGN_CREATE_INFO = "lysjdm.sign.create.info";
    /**
     * 查询签名设备信息
     */
    public static final String LYSJDM_SIGN_QUERY_QMSBXX = "lysjdm.sign.query.qmsbxx";


    //税务
    /**
     * 增量房核税
     */
    public static final String LYSJDM_SW_HS_ZLF = "lysjdm.sw.hs.zlf";
    /**
     * 存量房核税
     */
    public static final String LYSJDM_SW_HS_CLF = "lysjdm.sw.hs.clf";
    /**
     * 土地核税
     */
    public static final String LYSJDM_SW_HS_TD = "lysjdm.sw.hs.td";
    /**
     * 获取申报信息
     */
    public static final String LYSJDM_SW_HQSBXX = "lysjdm.sw.hs.hqsbxx";
    /**
     * 确认申报信息
     */
    public static final String LYSJDM_SW_QRSBXX = "lysjdm.sw.hs.qrsbxx";
    /**
     * 获取完税信息
     */
    public static final String LYSJDM_SW_WSXX_HQ = "lysjdm.sw.wsxx.hq";
    /**
     * 获取完税凭证
     */
    public static final String LYSJDM_SW_WSPZ_HQ = "lysjdm.sw.wspz.hq";
    /**
     * 下载完税凭证
     */
    public static final String LYSJDM_SW_WSPZ_DOWNLOAD = "lysjdm.sw.wspz.download";
    /**
     * 获取契税联系单
     */
    public static final String LYSJDM_SW_QSLXD_HQ = "lysjdm.sw.qslxd.hq";
    /**
     * 生成缴税二维码
     */
    public static final String LYSJDM_SW_PAY = "lysjdm.sw.pay";
    /**
     * 缴款结果查询
     */
    public static final String LYSJDM_SW_JKJGCX = "lysjdm.sw.jkjgcx";
    /**
     * 获取缴税明细
     */
    public static final String LYSJDM_SW_HQJSMX = "lysjdm.sw.hqjsmx";
    /**
     * 获取税务统缴明细
     */
    public static final String LYSJDM_SW_HQSFTJMX = "lysjdm.sw.hqsftjmx";
    /**
     * 获取电子税票
     */
    public static final String LYSJDM_SW_HQDZSP = "lysjdm.sw.hqdzsp";
    /**
     * 获取电子发票
     */
    public static final String LYSJDM_SW_HQDZFP = "lysjdm.sw.hqdzfp";
    /**
     * 获取电子发票清单
     */
    public static final String LYSJDM_SW_HQDZFPQD = "lysjdm.sw.hqdzfpqd";
    /**
     * 获取上手契税税票清单
     */
    public static final String LYSJDM_SW_HQSSQSSPQD = "lysjdm.sw.hqssqsspqd";
    /**
     * 获取电子发票单票
     */
    public static final String LYSJDM_SW_HQDZFPDP = "lysjdm.sw.hqdzfpdp";
    /**
     * 获取上手契税税票单票
     */
    public static final String LYSJDM_SW_HQSSQSSPDP = "lysjdm.sw.hqssqsspdp";
    /**
     * 获取电子发票--登记费
     */
    public static final String LYSJDM_SW_HQDZFP_DJF = "lysjdm.sw.hqdzfp.djf";
    /**
     * 下载电子发票
     */
    public static final String LYSJDM_SW_DOWNLOADDZFP = "lysjdm.sw.downloaddzfp";
    /**
     * 获取三要素
     */
    public static final String LYSJDM_SW_SYS = "lysjdm.sw.sys";
    /**
     * 生成订单
     */
    public static final String LYSJDM_SW_SCDD = "lysjdm.sw.scdd";
    /**
     * 生成订单--生成登记费
     */
    public static final String LYSJDM_SW_SCDD_DJF = "lysjdm.sw.scdd.djf";
    /**
     * 生成订单v3.0
     */
    public static final String LYSJDM_SW_SCDD_V3 = "lysjdm.sw.scdd.v3";
    /**
     * 查询订单
     */
    public static final String LYSJDM_SW_CXDDXX = "lysjdm.sw.cxddxx";
    /**
     * 查询订单--批量登记费
     */
    public static final String LYSJDM_SW_CXDDXX_PL_DJF = "lysjdm.sw.cxddxx.pl.djf";
    /**
     * 更新订单
     */
    public static final String LYSJDM_SW_GXDDXX = "lysjdm.sw.gxddxx";
    /**
     * 查询订单
     */
    public static final String LYSJDM_SW_CXDDXX_V2 = "lysjdm.sw.cxddxx.v2";
    /**
     * 生成订单
     */
    public static final String LYSJDM_SW_JFMX_QUERY = "lysjdm.sw.jfmx.query";
    /**
     * 获取缴款链接
     */
    public static final String LYSJDM_SW_JKLJ_QUERY = "lysjdm.sw.jklj.query";
    /**
     * 税务核税推送附件
     */
    public static final String LYSJDM_SW_HS_TSFJ = "lysjdm.sw.hs.tsfj";
    /**
     * 税务税款报文回调通知
     */
    public static final String LYSJDM_SW_SKBW_NOTICE = "lysjdm.sw.skbw.notice";
    /**
     * 缴费状态推送
     */
    public static final String LYSJDM_SW_JFZT_TZ = "lysjdm.sw.jfzt.tz";
    /**
     * 缴费状态推送
     */
    public static final String LYSJDM_SW_JKZT_TZ = "lysjdm.sw.jkzt.tz";
    /**
     * 缴库推送
     */
    public static final String LYSJDM_SW_JK = "lysjdm.sw.jk";
    /**
     * 退款
     */
    public static final String LYSJDM_SW_TK = "lysjdm.sw.tk";
    /**
     * 查询退款状态
     */
    public static final String LYSJDM_SW_CXTKZT = "lysjdm.sw.cxtkzt";
    /**
     * 线下缴费更新状态
     */
    public static final String LYSJDM_SW_XXJFGXZT = "lysjdm.sw.xxjfgxzt";

    /**
     * 推送缴费链接到第三方
     */
    public static final String LYSJDM_SW_TSJFLJ_THIRD = "lysjdm.sw.tsjflj.third";

    /**
     * 家庭成员查询
     */
    public static final String LYSJDM_JTCY_QUERY = "lysjdm.jtcy.query";

    /**
     * 房屋套次查询
     */
    public static final String LYSJDM_JTCY_FWTC = "lysjdm.jtcy.fwtc";

    /**
     * 房屋套次验证
     */
    public static final String LYSJDM_JTCY_FWTCCHECK = "lysjdm.jtcy.fwtccheck";

    /**
     * 推送交易备案信息
     */
    public static final String LYSJDM_JYXX_TSJYBAXX = "lysjdm.jyxx.tsjybaxx";

    /**
     * 交易备案结果接收
     */
    public static final String LYSJDM_JYXX_JYBAJGJS = "lysjdm.jyxx.jybajgjs";


    /**
     * 交易备案申请
     */
    public static final String LYSJDM_JYXX_BAXXSQ = "lysjdm.jyxx.baxxsq";

    /**
     * 交易备案申请状态查询
     */
    public static final String LYSJDM_JYXX_BAXXZT_QUERY = "lysjdm.jyxx.baxxzt.query";

    /**
     * 免监管申请状态查询
     */
    public static final String LYSJDM_JYXX_MJGZT_QUERY = "lysjdm.jyxx.mjgzt.query";

    /**
     * 交易合同附件获取
     */
    public static final String LYSJDM_JYXX_JYHTHQ = "lysjdm.jyxx.jyhthq";
    /**
     * 交易合同信息获取
     */
    public static final String LYSJDM_JYXX_JYHTXXHQ = "lysjdm.jyxx.jyhtxxhq";
    /**
     * 交易合同推送
     */
    public static final String LYSJDM_JYXX_JYHTXXTS = "lysjdm.jyxx.jyhtxxts";
    /**
     * 线下交易备案合同附件获取
     */
    public static final String LYSJDM_JYXX_XX_JYHTFJHQ = "lysjdm.jyxx.xx.jyhtfjhq";

    /**
     * 收费信息保存
     */
    public static final String LYSJDM_SFXX_SAVE = "lysjdm.sfxx.save";

    /**
     * 银行直连收费信息保存
     */
    public static final String LYSJDM_SFXX_SAVE_YHZL = "lysjdm.sfxx.save.yhzl";
    /**
     * 收费信息保存
     */
    public static final String LYSJDM_SFXX_DELETE = "lysjdm.sfxx.delete";
    /**
     * 收费信息详情
     */
    public static final String LYSJDM_SFXX_DETAIL = "lysjdm.sfxx.detail";
    /**
     * 收费收税信息缴纳
     */
    public static final String LYSJDM_SFSSXX_JN = "lysjdm.sfssxx.jn";

    /**
     * 电费用查询
     */
    public static final String LYSJDM_SDQ_DY_QUERY = "lysjdm.sdq.dy.query";
    /**
     * 水费用查询
     */
    public static final String LYSJDM_SDQ_SY_QUERY = "lysjdm.sdq.sy.query";

    /**
     * 省厅身份核验
     */
    public static final String LYSJDM_STGX_THIRD_CHECK = "lysjdm.stgx.third.check";

    /**
     * 不动产登记电子证照预览
     */
    public static final String LYSJDM_BDCDJ_DZZZ_VIEW = "lysjdm.bdcdj.dzzz.view";

    /**
     * 不动产登记电子证照下载
     */
    public static final String LYSJDM_BDCDJ_DZZZ_DOWNLOAD = "lysjdm.bdcdj.dzzz.download";

    /**
     * 不动产登记电子证照查询
     */
    public static final String LYSJDM_BDCDJ_DZZZ_QUERY = "lysjdm.bdcdj.dzzz.query";

    /**
     * 不动产登记电子证照分页查询
     */
    public static final String LYSJDM_BDCDJ_DZZZFY_QUERY = "lysjdm.bdcdj.dzzzfy.query";

    /**
     * 一件事推送申请信息
     */
    public static final String LYSJDM_ONETHING_PUSH_SQXX = "lysjdm.onething.push.sqxx";

    /**
     * 第三方合同信息获取
     */
    public static final String LYSJDM_ESIGN_SYSXXBD = "lysjdm.esign.sysxxbd";

    public static final String LYSJDM_JFMX_QUERY = "lysjdm.jfmx.query";

    /**
     * 预告信息查询
     */
    public static final String LYSJDM_QUERY_YGXX = "lysjdm.query.ygxx";

    /**
     * 预告、预抵押查询
     */
    public static final String LYSJDM_QUERY_YG_AND_YGDY = "lysjdm.query.yg.and.ygdy";

    /**
     * 预抵押查询
     */
    public static final String LYSJDM_QUERY_YGDYXX = "lysjdm.query.ygdyxx";

    /**
     * 预告信息保存
     */
    public static final String LYSJDM_SQXX_YGYDYXX_SAVEORUPDATE = "lysjdm.sqxx.ygydyxx.saveOrUpdate";

    /**
     * 查封信息批量保存事件
     */
    public static final String LYSJDM_SQXX_CFXX_BATCH_SAVEORUPDATE = "lysjdm.sqxx.cfxx.batch.saveOrUpdate";

    /**
     * 签字板查询签署信息
     */
    public static final String LYSJDM_SIGN_BOARD_QUERY_QSXX = "lysjdm.sign.board.query.qsxx";

    /**
     * 签字板签字验证
     */
    public static final String LYSJDM_SIGN_BOARD_CURRENCY_VERIFY = "lysjdm.sign.board.currency.verify";

    /**
     * 签名pdf合并事件
     */
    public static final String LYSJDM_SIGN_QM_PDF_COMBINE = "lysjdm.sign.qm.pdf.combine";

    /**
     * 签名pdf合并事件（产权查询授权）
     */
    public static final String LYSJDM_SIGN_QM_PDF_CQCXSQ_COMBINE = "lysjdm.sign.qm.pdf.cqcxsq.combine";

    /**
     * 宗地保存事件
     */
    public static final String LYSJDM_SQXX_ZDXX_SAVEORUPDATE = "lysjdm.sqxx.zdxx.saveOrUpdate";

    /**
     * 宗地批量保存事件
     */
    public static final String LYSJDM_SQXX_ZDXX_BATCH_SAVEORUPDATE = "lysjdm.sqxx.zdxx.batch.saveOrUpdate";

    /**
     * E签宝身份认证事件
     */
    public static final String LYSJDM_ESIGN_VERIFY = "lysjdm.esign.verify";

    /**
     * E签宝身份认证结果事件
     */
    public static final String LYSJDM_ESIGN_VERIFY_RESULT = "lysjdm.esign.verify.result";

    /**
     * 第三方资金监管信息获取
     */
    public static final String LYSJDM_THIRD_ZJJGXX = "lysjdm.third.zjjgxx";

    /**
     * gsb服务  身份证信息查询
     */
    public static final String LYSJDM_THIRD_GSB_SFZXX = "lysjdm.third.gsb.sfzxx";

    /**
     * gsb服务  营业执照查询
     */
    public static final String LYSJDM_THIRD_GSB_YYZZ = "lysjdm.third.gsb.yyzz";
    /**
     * gsb服务  户籍信息查询
     */
    public static final String LYSJDM_THIRD_GSB_HJXX = "lysjdm.third.gsb.hjxx";
    /**
     * gsb服务  婚姻信息查询
     */
    public static final String LYSJDM_THIRD_GSB_HYXX = "lysjdm.third.gsb.hyxx";
    /**
     * 土地承包经营保存事件
     */
    public static final String LYSJDM_SQXX_TDCBJY_SAVEORUPDATE = "lysjdm.sqxx.tdcbjy.saveOrUpdate";

    /**
     * 破产管理初始化领域事件
     */
    public static final String LYSJDM_PCGL_INIT = "lysjdm.pcgl.init";

    /**
     * 破产管理申请领域事件
     */
    public static final String LYSJDM_PCGL_APPLY = "lysjdm.pcgl.apply";

    /**
     * 破产管理保存领域事件
     */
    public static final String LYSJDM_PCGL_SAVE = "lysjdm.pcgl.save";
    /**
     * 通用申请初始化领域事件
     */
    public static final String LYSJDM_COMMON_INIT = "lysjdm.common.init";
    /**
     * 通用申请保存领域事件
     */
    public static final String LYSJDM_COMMON_APPLY = "lysjdm.common.apply";
    /**
     * 通用申请审核领域事件
     */
    public static final String LYSJDM_COMMON_APPROVE = "lysjdm.common.approve";
    /**
     * 领域事件修改密码
     */
    public static final String LYSJDM_UPDATE_PWD = "lysjdm.update.pwd";
    /**
     * 更新受理状态
     */
    public static final String LYSJDM_UPDATE_SlZT = "lysjdm.update.slzt";
    /**
     * 登记资料审核通知
     */
    public static final String LYSJDM_DJZLCXSQ_SHTZ = "lysjdm.djzlcxsq.shtz";

    /**
     * 土地经营保存事件
     */
    public static final String LYSJDM_SQXX_TDJY_SAVEORUPDATE = "lysjdm.sqxx.tdjy.saveOrUpdate";

    /**
     * 税务核税，推送价格明细单
     */
    public static final String LYSJDM_SW_HS_TSJGMXD = "lysjdm.sw.hs.tsjgmxd";

    /**
     * 维修基金获取缴费地址
     */
    public static final String LYSJDM_WXJJ_HQJFDZ = "lysjdm.wxjj.hqjfdz";

    /**
     * 维修基金不缴存通知
     */
    public static final String LYSJDM_WXJJ_BJCTZ = "lysjdm.wxjj.bjctz";

    /**
     * 维修基金不缴存通知
     */
    public static final String LYSJDM_WXJJ_JFZTTS = "lysjdm.wxjj.jfztts";

    /**
     * 维修基金缴存开户
     */
    public static final String LYSJDM_WXJJ_JCKH = "lysjdm.wxjj.jckh";

    /**
     * 维修基金缴存查询
     */
    public static final String LYSJDM_WXJJ_JFZTCX = "lysjdm.wxjj.jfztcx";
    /**
     * 开发商授权批量
     */
    public static final String LYSJDM_SQXX_KFSSQ_SAVE_PL = "lysjdm.sqxx.kfssq.save.pl";

    /**
     * 不动产登记抵押物清单下载
     */
    public static final String LYSJDM_BDCDJ_DYWQD_DOWNLOAD = "lysjdm.bdcdj.dywqd.download";
    /**
     * 月结缴费查询
     */
    public static final String LYSJDM_YJ_CXJFXX = "lysjdm.yj.cxjfxx";
    /**
     * 月结缴费查询所有
     */
    public static final String LYSJDM_YJ_CXJFXXALL = "lysjdm.yj.cxjfxxall";
    /**
     * 生成月结单号
     */
    public static final String LYSJDM_YJ_SCYJDH = "lysjdm.yj.scyjdh";
    /**
     * 生成月结订单
     */
    public static final String LYSJDM_YJ_SCDD = "lysjdm.yj.scdd";
    /**
     * 查询月结订单信息
     */
    public static final String LYSJDM_YJ_CXDDXX = "lysjdm.yj.cxddxx";
    /**
     * 获取月结电子发票模型
     */
    public static final String LYSJDM_YJ_DZFPMX = "lysjdm.yj.dzfpmx";
    /**
     * 获取我的待缴费信息
     */
    public static final String LYSJDM_GR_PAYMENT = "lysjdm.gr.payment";
    /**
     * 获取缴费识别码
     */
    public static final String LYSJDM_SW_HQJFSBM = "lysjdm.sw.hqjfsbm";
    /**
     * 不动产登记抵押物清单下载
     */
    public static final String LYSJDM_WSPZ_DOWNLOAD = "lysjdm.wspz.download";
    /**
     * 抵押查询导出excel领域事件代码
     */
    public static final String LYSJDM_EXCEL_DYCX = "lysjdm.excel.dycx";
    /**
     * 收费信息保存
     */
    public static final String LYSJDM_DY_SFXX_SAVE = "lysjdm.dy.sfxx.save";
    /**
     * 发起评价--摩科
     */
    public static final String LYSJDM_MK_FQPJ = "lysjdm.mk.fqpj";
    /**
     * 发起高拍仪--摩科
     */
    public static final String LYSJDM_MK_FQGPY = "lysjdm.mk.fqgpy";
    /**
     * 获取高拍仪图片--摩科
     */
    public static final String LYSJDM_MK_HQGPYTP = "lysjdm.mk.hqgpytp";
    /**
     * 登记资料查询保存
     */
    public static final String LYSJDM_DJZLCX_SAVE = "lysjdm.djzlcx.save";
    /**
     * 登记资料查询提交
     */
    public static final String LYSJDM_DJZLCX_QRTJ = "lysjdm.djzlcx.qrtj";
    /**
     * 登记资料查询申请推送登记
     */
    public static final String LYSJDM_DJZLCXSQ_PUSH_DJ = "lysjdm.djzlcxsq.push.dj";
    /**
     * 公证书信息核验
     */
    public static final String LYSJDM_STGX_GZSXX_HY = "lysjdm.stgx.gzsxx.hy";
    /**
     * 推送登记系统--税务核验
     */
    public static final String LYSJDM_SQXX_PUSH_DJ_SWHY = "lysjdm.sqxx.push.dj.swhy";
    /**
     * 云签--查询企业经办人
     */
    public static final String LYSJDM_SIGN_QUERY_QYJBR = "lysjdm.sign.query.qyjbr";
    /**
     * 住建房管推送创建
     */
    public static final String LYSJDM_SQXX_ZJFG_CREATE = "lysjdm.sqxx.zjfg.create";
    /**
     * 物流信息保存
     */
    public static final String LYSJDM_SQXX_WLXX_SAVE = "lysjdm.sqxx.wlxx.save";
    /**
     * 过户信息保存
     */
    public static final String LYSJDM_GHXX_SAVE = "lysjdm.ghxx.save";
    /**
     * 推送登记系统 过户信息审核结果
     */
    public static final String LYSJDM_GHXX_SHJG_PUSH_DJ = "lysjdm.ghxx.shjg.push.dj";
    /**
     * 政务服务业务中枢推送转移
     */
    public static final String LYSJDM_ZWFWYWZS_PUSH_ZY = "lysjdm.zwfwywzs.push.zy";
}
