/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.pdf;

import cn.gtmap.estateplat.core.support.xml.XmlUtils;
import cn.gtmap.estateplat.model.server.print.FdcqDzxx;
import cn.gtmap.estateplat.model.server.print.FdcqDzxxPage;
import cn.gtmap.estateplat.model.server.print.XmlData;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.dto.pdf.manage.OfficeDataToPrintXmlDTO;
import cn.gtmap.hlw.core.util.pdf.FilePathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfExportUtils.class);

    public static String getxmlPath(OfficeDataToPrintXmlDTO officeDataToPrintXml, String slbh, String path) {
        String filePath;
        boolean bcwjYz;
        XmlUtils resultBinder = new XmlUtils(new Class[]{OfficeDataToPrintXmlDTO.class});
        String xml = resultBinder.entityToXml((Object)officeDataToPrintXml, "UTF-8");
        xml = xml.replace("null", "");
        String filePt = path.substring(0, path.indexOf(File.separator)) + File.separator + PdfExportUtils.getFilePath(slbh, UUID.randomUUID().toString());
        File file = new File(filePt);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        if (bcwjYz = PdfExportUtils.outputStreamWriterXml(xml, filePath = filePt + File.separator + slbh + UUID.randomUUID().toString() + ".xml")) {
            return filePath;
        }
        return null;
    }

    public static String getFilePath(String slbh, String fjlxdm) {
        String date = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        return FilePathUtil.addDateDirectoriesToFilePath("fileCenter" + File.separator + "pdf_export" + File.separator + slbh + File.separator + fjlxdm + File.separator + date, "fileCenter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean outputStreamWriterXml(String content, String filePath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filePath, content})) {
            return false;
        }
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8);
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            LOGGER.error("outputStreamWriterXml:IOException:", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("outputStreamWriterXml:IOException:", (Throwable)e);
            }
        }
        return true;
    }

    public static XmlData zzData(String name, String type, String value) {
        XmlData xmlData = new XmlData();
        xmlData.setName(name);
        xmlData.setType(type);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = "";
        }
        xmlData.setValue(value);
        return xmlData;
    }

    public static void createYqZb(List<String> qlrZjhList, String zbId, List<FdcqDzxxPage> fdcqDzxxPageList) {
        FdcqDzxxPage qlrYqDetail = new FdcqDzxxPage();
        ArrayList<FdcqDzxx> qlrYqZb = new ArrayList<FdcqDzxx>();
        if (CollectionUtils.isNotEmpty(qlrZjhList)) {
            for (String qlrZjh : qlrZjhList) {
                ArrayList<XmlData> yqZbDataList = new ArrayList<XmlData>();
                FdcqDzxx yqItem = new FdcqDzxx();
                yqItem.setId("\u6743\u5229\u4eba\u5b50\u9879");
                yqZbDataList.add(PdfExportUtils.zzData("qlrYq_0_100", "String", CommonUtil.formatEmptyValue((Object)("\u7b7e\u5b57\u533a_" + qlrZjh))));
                yqItem.setXmlDataList(yqZbDataList);
                qlrYqZb.add(yqItem);
            }
        } else {
            ArrayList<XmlData> yqZbDataList = new ArrayList<XmlData>();
            FdcqDzxx yqItem = new FdcqDzxx();
            yqItem.setId("\u6743\u5229\u4eba\u5b50\u9879");
            yqZbDataList.add(PdfExportUtils.zzData("qlrYq_0_100", "String", CommonUtil.formatEmptyValue((Object)"")));
            yqItem.setXmlDataList(yqZbDataList);
            qlrYqZb.add(yqItem);
        }
        qlrYqDetail.setId(zbId);
        qlrYqDetail.setRow(qlrYqZb);
        fdcqDzxxPageList.add(qlrYqDetail);
    }
}

