/**













 */
package cn.gtmap.hlw.core.node;

import java.util.ArrayList;
import java.util.List;

/**
 * 森林管理类
 *
 *
 */
public class ForestNodeManager<T extends INode<T>> {

	/**
	 * 森林的所有节点
	 */
	private final List<T> list;

	/**
	 * 森林的父节点ID
	 */
	private final List<String> parentIds = new ArrayList<>();

	public ForestNodeManager(List<T> items) {
		list = items;
	}

	/**
	 * 增加父节点ID
	 *
	 * @param parentId 父节点ID
	 */
	public void addParentId(String parentId) {
		parentIds.add(parentId);
	}

	/**
	 * 获取树的根节点(一个森林对应多颗树)
	 *
	 * @return 树的根节点集合
	 */
	public List<T> getRoot() {
		final List<T> roots = new ArrayList<>();
		for (final T forestNode : list) {
			if ("0".equals(forestNode.getParentId()) || parentIds.contains(forestNode.getId())) {
				roots.add(forestNode);
			}
		}
		return roots;
	}

	/**
	 * 根据节点ID获取一个节点
	 *
	 * @param id 节点ID
	 * @return 对应的节点对象
	 */
	public INode getTreeNodeAt(String id) {
		for (final INode forestNode : list) {
			if (forestNode.getId().equals(id)) {
				return forestNode;
			}
		}
		return null;
	}

}
