package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/8/7
 * @description 备案状态枚举
 */
@Getter
@AllArgsConstructor
public enum BaztEnum {

    /**
     * 未备案
     */
    BAZT_WBA("0", "未备案"),
    /**
     * 已备案
     */
    BAZT_YBA("1", "已备案"),
    /**
     * 审核不通过
     */
    BAZT_SHBTG("2", "审核不通过"),
    /**
     * 撤销
     */
    BAZT_CX("3", "撤销"),
    /**
     * 变更
     */
    BAZT_BG("4", "变更"),

    /**
     * 备案中
     */
    BAZT_BAZ("5", "备案中"),
    /**
     * 备案申请失败
     */
    BAZT_BASQSB("6", "备案申请失败"),
    /**
     * 备案查询失败
     */
    BAZT_BACXSB("7", "备案查询失败"),
    /**
     * 免监管凭证已提交
     */
    BAZT_MJGPZYTJ("8", "免监管凭证已提交"),
    /**
     * 提交免监管凭证失败
     */
    BAZT_TJMJGPZSB("9", "提交免监管凭证失败"),
    /**
     * 免监管凭证查询失败
     */
    BAZT_MJGPZCXSB("10", "免监管凭证查询失败"),
    /**
     * 免监管凭证审核通过
     */
    BAZT_MJGPZSHTG("11", "免监管凭证审核通过"),
    /**
     * 免监管凭证审核退回
     */
    BAZT_MJGPZSHTH("12", "免监管凭证审核退回");

    /**
     * 代码
     */
    @Getter
    private String dm;

    /**
     *    名称
     */
    @Getter
    private String mc;

    public static String getMc(String dm) {
        for (BaztEnum xq : BaztEnum.values()) {
            if (xq.dm.equals(dm)) {
                return xq.getMc();
            }
        }
        return null;
    }
}
