package cn.gtmap.hlw.core.dto.sqxx.tz;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import cn.gtmap.hlw.core.dto.sw.scdd.ScddBdcWxjjxxDTO;
import cn.gtmap.hlw.core.dto.sw.scdd.SwJfmxBdcSfxxDTO;
import cn.gtmap.hlw.core.dto.sw.scdd.SwJfmxBdcSlSqrDO;
import cn.gtmap.hlw.core.dto.sw.scdd.SwJfmxBdcSwxxDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/29 16:26
 * @description SqxxTzResultDTO
 */
@Data
public class SqxxTzResultDTO {
    /**
     * 查询唯一标识
     */
    private String rowguid;
    /**
     * slbh
     */
    private String slbh;
    /**
     * 业务系统slbh
     */
    private String ywxtslbh;

    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlx;

    private String sqdjlx;

    /**
     * 申请类型名称 gx_yy_zd_sqlx.mc
     */
    private String sqlxmc;

    /**
     * 权利人名称(转移流程qlrmc)
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.qlrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.qlrmc
     */
    private String qlrmc;

    private String qlrzjh;

    /**
     * 义务人名称
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.ywrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.ywrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.ywrmc
     */
    private String ywrmc;

    private String ywrzjh;

    /**
     * 抵押权人名称
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.qlrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.qlrmc
     */
    private String dyqr;

    /**
     * 坐落 gx_yy_sqxx.zl
     */
    private String zl;

    /**
     * 受理状态 gx_yy_sqxx.slzt
     */
    private Integer slzt;

    /**
     * 受理状态 gx_yy_sqxx.slxx
     */
    private String slxx;

    /**
     * 受理状态名称 gx_yy_zd_type.zd_type=SLZT gx_yy_zd_type.mc
     */
    @ZdTypeConfig(field = "slzt", tableName = ZdTypeConstant.ZD_TYPE_SLZT, dmToMc = true)
    private String slztmc;

    /**
     * 税务状态 gx_yy_sqxx.swzt
     */
    private String swzt;

    /**
     * 税务状态名称 gx_yy_zd_type.zd_type=swzt gx_yy_zd_type.mc
     */
    @ZdTypeConfig(field = "swzt", tableName = ZdTypeConstant.ZD_TYPE_SWZT, dmToMc = true)
    private String swztmc;

    /**
     * 缴费状态 gx_yy_sqxx.jftz
     */
    private String jfzt;

    /**
     * 缴费状态 gx_yy_zd_type.zd_type=jftz gx_yy_zd_type.mc
     */
    @ZdTypeConfig(field = "jfzt", tableName = ZdTypeConstant.ZD_TYPE_JFZT, dmToMc = true)
    private String jfztmc;

    /**
     * 登记原因 gx_yy_sqxx.djyy
     */
    private String djyy;

    /**
     * 登记原因 gx_yy_sqxx.djyy = gx_yy_djyy.dm ;gx_yy_djyy.mc
     */
    private String djyymc;

    /**
     * 创建时间 gx_yy_sqxx.create_date
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDateShort;

    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 区域代码名称
     */
    private String qydmmc;
    /**
     * 签约类型
     */
    private String qylx;
    /**
     * 签约类型名称
     */
    @ZdTypeConfig(field = "qylx", tableName = ZdTypeConstant.ZD_TYPE_HTQYLX, dmToMc = true)
    private String qylxmc;
    /**
     * 备案状态
     */
    private String bazt;
    /**
     * 备案状态名称
     */
    @ZdTypeConfig(field = "bazt", tableName = ZdTypeConstant.ZD_TYPE_BAZT, dmToMc = true)
    private String baztmc;
    /**
     * 节点名称
     */
    private String jdmc;
    /**
     * 买卖合同号
     */
    private String mmhth;
    /**
     * 申请id
     */
    private String sqid;
    /**
     * 导出状态
     */
    private Integer dczt;
    /**
     * 创建人
     */
    private String createUser;
    /**
     * 创建人姓名
     */
    private String createUserName;
    /**
     * 创建人
     */
    private String createUserid;
    /**
     * 操作时间
     */
    private String editDate;
    /**
     * 审核人
     */
    private String editUser;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 导出人
     */
    private String dcr;
    /**
     * 备注
     */
    private String bz;
    /**
     * 云签方式
     */
    private String jddm;
    /**
     * 云签方式
     */
    private String yqfs;
    /**
     * 房产证号
     */
    private String fczhList;
    /**
     * 抵押证明号
     */
    private String dyzmh;
    /**
     * 预审台账状态
     */
    private String ystzzt;
    /**
     * 统计数量
     */
    private Integer totalCount;
    /**
     * 是否认证（1（否）  0（是））
     */
    private String sfrz;

    /**
     * 是否需要预审(0否，1是)
     */
    private String sfxyys;

    /**
     * 税务审核信息
     */
    private String swshxx;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 土地证号
     */
    private String tdzh;
    /**
     * 申请人联系电话
     */
    private String remark;

    /**
     * 申请人列表
     */
    private List<SwJfmxBdcSlSqrDO> bdcSlSqrDOS;

    /**
     * 收费信息集合
     */
    private List<SwJfmxBdcSfxxDTO> bdcSfxxDTOS;

    /**
     * 收税信息集合
     */
    private List<SwJfmxBdcSwxxDTO> bdcSwxxDTOS;
    /**
     * 维修基金信息集合
     */
    private List<ScddBdcWxjjxxDTO> bdcWxjjxxDTOS;

    /**
     * 数据来源：5：内网，7：互联网
     */
    private String sjly;

    /**
     * 权利人类别
     */
    private String qlrlb;

    /**
     * 预审状态
     */
    private String yszt;

    /**
     * 盖章状态
     */
    private String gzzt;

    /**
     * 维修基金状态
     */
    private String wxjjzt;
    /**
     * 维修基金状态
     */
    private String wxjjztmc;
    /**
     * 登记接收人名称
     */
    private String djjsrmc;
    /**
     * 备案状态说明
     */
    private String baztsm;

    /**
     * 用户真实名称
     */
    private String realName;
    /**
     * 是否云签
     */
    private String sfyq;
    /**
     * 申请号
     */
    private String sqh;
    /**
     * 缴费方式
     */
    private String jffs;
}
