package cn.gtmap.hlw.core.dao.dict;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.tk.ZdSqxxTkDetailParamsDTO;
import cn.gtmap.hlw.core.dto.dict.tk.ZdSqxxTkQueryDTO;
import cn.gtmap.hlw.core.model.GxYyZdSqxxTk;

import java.util.List;

/**
 * 在线申请--闻讯笔录--题库(GxYyZdSqxxTk)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
public interface GxYyZdSqxxTkDao {

    /**
     * 通过ID查询单条数据
     *
     * @param dm 主键
     * @return 实例对象
     */
    GxYyZdSqxxTk get(String dm);
    /**
     * 查询相同一类题库
     *
     * @param paramsDTO
     * @return 实例对象
     */
    List<GxYyZdSqxxTk> getBySqlxAndQlrlx(ZdSqxxTkDetailParamsDTO paramsDTO);

    /**
     * 新增数据
     *
     * @param gxYyZdSqxxTk 实例对象
     * @return 影响行数
     */
    void saveTk(GxYyZdSqxxTk gxYyZdSqxxTk);

    /**
     * 修改数据
     *
     * @param gxYyZdSqxxTk 实例对象
     * @return 影响行数
     */
    void updateTk(GxYyZdSqxxTk gxYyZdSqxxTk);

    /**
     * 获取数据
     *
     * @param qlrlx 权利人类型
     * @param sqlx  申请类型
     * @param dm
     * @return 影响行数
     */
    GxYyZdSqxxTk getSqxxTkListByQueryParams(String qlrlx, String sqlx, String dm);

    /**
     * 获取数据
     *
     * @param qlrlx 权利人类型
     * @param sqlx  申请类型
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getInitSqxxTkListByQueryParams(String qlrlx, String sqlx);
    /**
     * 获取数据
     *@param sqlx  申请类型
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getQlrLx(String sqlx);
    /**
     * 获取数据
     *@param sqlx  申请类型
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getBySqlx(String sqlx);
    /**
     * 获取数据
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getAll();

    /**
     *分页查询
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYyZdSqxxTk> queryPage(ZdSqxxTkQueryDTO paramsDTO);

    /**
     * 根据主键删除数据
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);

    /**
     * 根据申请类型删除数据
     * @param sqlx 申请类型
     * @return 删除的数据数量
     */
    int deleteBySqlx(String sqlx);

    /**
     * 保存更新
     * @param gxYyZdSqxxTk
     */
    void saveOrUpdateTk(GxYyZdSqxxTk gxYyZdSqxxTk);
    /**
     * 批量保存更新
     * @param gxYyZdSqxxTkList
     */
    void saveOrUpdateBatchTk(List<GxYyZdSqxxTk> gxYyZdSqxxTkList);

    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYyZdSqxxTkPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyZdSqxxTk> listBySqlx(String sqlx);
    /**
     * 批量保存
     * @param zdSqxxTkList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatchSomeColumn(List<GxYyZdSqxxTk> zdSqxxTkList);
}

