package cn.gtmap.hlw.core.dto.wxjj;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2024/12/16
 * @description 维修基金开户请求参数
 */
@Data
public class AhWxjjKhParamsDTO {
    /**
     * 不动产单元号（全局唯一）
     */
    private String propertyUnitNo;

    /**
     * 初始登记证号
     */
    private String firstRegisterNumber;

    /**
     * 合同编号
     */
    private String contractNumber;

    /**
     * 所在行政区域
     */
    @ZdTypeConfig(field = "zoneName", tableName = ZdTypeConstant.ZD_TYPE_XZQH, dmToMc = true)
    private String zoneName;
    /**
     * 小区名称
     */
    private String estateName;
    /**
     * 楼栋号：如果是门面房等没有楼栋号的请传0
     */
    private String buildingNumber;

    /**
     * 单元号：如果是门面房等没有单元号的请传0
     */
    private String entranceNumber;

    /**
     * 房号
     */
    private String unitNumber;

    /**
     * 房屋所在楼层
     */
    private String floor;
    /**
     * 楼栋总楼层数
     */
    private String buildFloor;
    /**
     * 房屋坐落
     */
    private String location;
    /**
     * 房屋类型编码
     */
    private String houseTypeCode;
    /**
     * 房屋类型名称
     */
    @ZdTypeConfig(field = "houseTypeName", tableName = ZdTypeConstant.ZD_TYPE_FWLX, dmToMc = true)
    private String houseTypeName;
    /**
     * 房屋性质编码
     */
    private String houseKindCode;
    /**
     * 房屋性质名称
     */
    @ZdTypeConfig(field = "houseKindName", tableName = ZdTypeConstant.ZD_TYPE_FWXZ, dmToMc = true)
    private String houseKindName;
    /**
     * 房屋用途编码
     */
    private String housePurposeCode;
    /**
     * 房屋用途名称
     */
    @ZdTypeConfig(field = "housePurposeName", tableName = ZdTypeConstant.ZD_TYPE_FWYT, dmToMc = true)
    private String housePurposeName;
    /**
     * 房屋面积(m²)
     */
    private String constructionArea;
    /**
     * 交存比例：1.5-有电梯,1-无电梯
     */
    private String payRate;
    /**
     * 购房时间(日期格式：yyyyMMdd)
     */
    private String salesDate;
    /**
     * 购房税费价格(元)必填项,否则无法计算出维修资金
     */
    private String purchasePrice;
    /**
     * 产权人集合(没有可不传)，产权人字段如下
     */
    private List<AhWxjjOwnersDTO> owners;
    /**
     * 开户类型：1-一窗集成交存开户，2-网上交存开户
     */
    private String openType;
    /**
     * 业务流水号(网上交存时必传)
     */
    private String acceptCode;
    /**
     * 开户备注
     */
    private String openRemarks;
    /**
     * 请求编号（全局唯一，方便出错时查询相应报文日志）
     */
    private String requestNid;
    /**
     * 请求时间(日期格式：yyyyMMddhhmmss)
     */
    private String requestTime;
    /**
     * 地下楼层总数
     */
    private String undergroundFloor;
    /**
     * 专有(套内)建筑面积(m²)
     */
    private String internalArea;
    /**
     * 分摊面积(m²)
     */
    private String shareArea;
}
