/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) {
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = "80b1fc3914d4ac9d33ddc17dcf51adaba2104286c88583b851e00e4e53765c0426cf30d210040db769a0622f91aa20f9cdb09ea28a3fc9cffad5c3ca685408dfc780c90453ef5bd7af7b75c3c5ed7885d7ec7459b6597a87defbb0aec82830f8";
        String paramid = "04e183ddb2c632168cc4a08665d44b3ef80957bc776c8e578d62e781e1c2e26bdc1ffc00fd3447acc9601fb50d9524716fa6f89a730b9943fa5800e7df7aa52b4c088eb1033fc2556046eba13cdb88b77a81e6eb63d05c1d39855a62e349163cf7dcbf87f63e22496e0cfc5d96c44d9bb777ce75c7d0bc9790145a2c7ee7a7d57c29645b0dd4ccf465a6c44954";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        String encryptStr = "{\"slbh\":\"W202503190079\",\"processId\":\"b912481754e64dfea519b07745f68dc7\",\"anid\":\"\"}";
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);
        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);
        System.out.println(JSON.toJSONString((Object)body));
    }
}

