package cn.gtmap.hlw.core.util.session;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.constant.Constants;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.jwt.Jwt;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/6/27
 * @description
 */
public class SessionUtil {

    /**
     * @param
     * @return:UserInfo
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @description 获取用户对象
     */
    public static UserInfo getUser() {
        final HttpServletRequest request = getRequest();
        if (request == null) {
            return null;
        }
        // 优先从 request 中获取
        Object user = request.getAttribute(Constants.ACCEPT_USER_REQUEST_ATTR);
        if (user == null) {
            user = getUser(request);
            if (user != null) {
                // 设置到 request 中
                request.setAttribute(Constants.ACCEPT_USER_REQUEST_ATTR, user);
            }
        }
        return (UserInfo) user;
    }

    /**
     * @param
     * @return:realName
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 获取当前登陆人真实姓名
     */
    public static String getUserRealName() {
        UserInfo userInfo = getUser();
        if (userInfo != null) {
            return userInfo.getRealName();
        }
        return StringUtils.EMPTY;
    }

    /**
     * @param
     * @return:realName
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 获取当前登陆人id
     */
    public static String getUserId() {
        UserInfo userInfo = getUser();
        if (userInfo != null) {
            return userInfo.getUserGuid();
        }
        return StringUtils.EMPTY;
    }

    public static HttpServletRequest getRequest() {
        final RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes) requestAttributes).getRequest();
    }

    /**
     * @param request
     * @return:UserInfo
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @description 获取用户对象
     */
    public static UserInfo getUser(HttpServletRequest request) {
        String token = request.getHeader(Constants.TOKEN);
        UserInfo userInfo = new UserInfo();
        if (StringUtils.isNoneEmpty(token)) {
            Map<String, String> map = Jwt.getPayload(token);
             userInfo = (UserInfo) BeanConvertUtil.convertMap(map, UserInfo.class);
        }
        return userInfo;
    }
}
