package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 节点信息状态(GxYySqlxJdxxZt)表实体类BO
 *
 * @author makejava
 * @since 2023-06-01 15:07:05
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqlxJdxxZt implements Serializable {
    private static final long serialVersionUID = -1955976750040114781L;
    /**
     * 节点状态id
     */
    private String jdztid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 节点id
     */
    private String jzid;

    /**
     * 节点类型（1:登记状态2：完税状态3：全流程状态）
     */
    private String jdlx;

    /**
     * 申请类型代码
     */
    private String sqlxdm;

    /**
     * 节点代码
     */
    private String jddm;

    /**
     * 节点名称
     */
    private String jdmc;

    /**
     * 节点名称顺序号
     */
    private Integer jdsxh;

    /**
     * 节点状态（0：未执行；1：成功；2：失败）
     */
    private String jdzt;

    /**
     * 节点状态说明
     */
    private String jdztsm;

    /**
     * 备注
     */
    private String bz;

    /**
     * 节点级别
     */
    private String jdjb;

    /**
     * 父节点名称
     */
    private String fjddm;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 修改人员(gx_yy_user.USER_GUID)
     */
    private String updateUser;

    /**
     * 方法类型(page:页面,method:方法）
     */
    private String fflx;

    /**
     * 地址
     */
    private String url;
    /**
     * 异常信息
     */
    private String ycxx;
    /**
     * 云签方式（1：线上/手机端云签，2：线下/签字版云签）
     */
    private String yqfs;
}

