package cn.gtmap.hlw.core.dto.exchange.push;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 订单信息
 */
@Data
public class PushDdxxDTO {
    /**
     * 订单编号
     */
    private String ddbh;
    /**
     * 订单金额
     */
    private String ddje;
    /**
     * 缴费人唯一识别(微信用户的openid或web的user_guid)
     */
    private String jfrdm;

    /**
     * 缴费方式(1：微信支付 2：网关支付 3：快捷支付,4:支付宝支付)
     */
    private String jffs;

    /**
     * 商户代码
     */
    private String shdm;

    /**
     * 商户名称
     */
    private String shmc;

    /**
     * 订单时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date ddsj;

    /**
     * 订单来源(1：微信 2：网页3：APP)
     */
    private String ddly;

    /**
     * 缴费状态(0：未缴费  1：已缴费,2:已退款，3:退款中)
     */
    private String jfzt;

    /**
     * 缴费信息主键
     */
    private String jfxxid;

    /**
     * 订单状态（0：关闭  1：激活）
     */
    private String ddzt;

    /**
     * IP地址
     */
    private String ip;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 缴费URL
     */
    private String url;

    /**
     * 业务系统受理编号
     */
    private String ywxtslbh;

    /**
     * 登记推送状态
     */
    private String djtszt;

    /**
     * 银行推送状态
     */
    private String yhtszt;

    /**
     * 第三方订单编号
     */
    private String dsfddbh;

    /**
     * 申请id（gx_yy_sqxx表sqid，主要是为了兼容拆单缴费）
     */
    private String sqid;

    /**
     * 缴费人名称
     */
    private String jfrmc;

    /**
     * 权利人类别(1:权利人，2义务人，3抵押权人,6：公积金抵押权人 )
     */
    private String qlrlb;

    /**
     * 收费类型(桦南) 0登记费 1房改售房款 2土地出让金 3维修资金
     */
    private String sflx;

    /**
     * 财政缴款码
     */
    private String czjkm;

    /**
     * 缴款日期
     */
    private String jkrq;

    /**
     * 缴款渠道代码
     */
    private String jkqddm;

    /**
     * 缴款银行
     */
    private String jkyh;
    /**
     * 缴费类型 1:单独缴费 2:单独缴税 3:税费同缴
     */
    private String jflx;
    /**
     * 商户号
     */
    private String shh;
    /**
     * 终端号
     */
    private String zdh;
    /**
     * pos流水号
     */
    private String poslsh;
    /**
     * 参考号
     */
    private String ckh;
    /**
     * 银行转交日期
     */
    private String yhzjrq;
    /**
     * POS机信息录入人员
     */
    private String poslrry;
    /**
     * POS机信息录入时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date poslrsj;
    /**
     * 打印缴款书时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date dyjkssj;
}
