package cn.gtmap.hlw.core.dto.dypz;

import lombok.Data;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2024/6/5
 * @description Pdf导出信息实体定义
 */
@Data
public class OfficeExportDTO {
    /**
     * PDF模板名称，也就是模板路径，可以是应用磁盘路径，也可以是http网络路径，例如大云storage文件路径（模板和FR3打印模板放置一个位置）
     */
    private String modelName;

    /**
     * 对应的FR3打印数据（PDF打印不单独做数据源获取配置，直接和FR3打印共用，只是最终用于不同的用途）
     */
    private String xmlData;

    /**
     * 导出的文件名
     */
    private String fileName;

    /**
     * 本地缓存文件名称
     */
    private String localFile;

    @Override
    public String toString() {
        return "PdfExportDTO{" +
                "modelName='" + modelName + '\'' +
                ", xmlData='" + xmlData + '\'' +
                ", fileName='" + fileName + '\'' +
                '}';
    }
}
