package cn.gtmap.hlw.core.enums.jdxx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/27
 * @description 银行审查
 */
@Getter
@AllArgsConstructor
public enum YhscEnum {
    /**
     * 待生成
     */
    DSC("0", "待审查"),
    /**
     * 生成成功
     */
    SCTG("1", "审查通过"),
    /**
     * 生成失败
     */
    SCWTG("2", "审查未通过");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (YhscEnum xq : YhscEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
