package cn.gtmap.hlw.core.dto.sign.create.params;

import lombok.Data;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/8 15:24
 * @description 主要数据来源：gx_yy_lcdy_pz
 */
@Data
public class SignFlowsCreateQsrxxQswjQsxxParamsDTO {
    /**
     * 签署类型
     * 0-不限(需用 户手动拖拽印章完成签 署，自动签署不支持)、
     * 1-单页签、
     * 2-多页签、
     * 3- 骑缝章、
     * 4关键字签；
     * 5-坐标   默认 4
     */
    private Integer qslx;
    /**
     * 签署页 -- 当文件存在多页，E签宝骑缝章可填写   默认不填
     * 例如（多页则传多组）：1
     * 例如（骑缝章）：1-5
     */
    private String qsy;
    /**
     * 关键字 关键字 若signType为4关键字签 则不能为空
     */
    private String key;
    /**
     * 指定签署第几个关键字 -1为最后一个,超过关键字总数选中最后一个；
     * 当关键字签传了posPage和keyIndex，表示在指定页里指定第几个关键字进行签署
     * 默认传空
     */
    private String keyIndex;
    /**
     * x轴偏移量
     * 正数向右偏移，
     * 负数向左偏移;
     * 单页签/多页签必填，
     * 相对页左下角为原点进行偏移；
     * 骑缝签无视该参数；
     * 关键字签非必填，
     * 以关键字的左下角为原点进行偏移
     */
    private String posX;

    /**
     * y轴偏移量
     * 正数向上偏移，
     * 负数向下偏移;
     * 单页签/多页签/骑缝签必填，
     * 以相对页左下角为原点进行偏移；
     * 关键字签非必填，以关键字的左下角为原点进行偏移
     */
    private String posY;

    /**
     * 签名域宽度
     * 为空则取 印章大小
     * 默认gx_yy_lcdy_pz.qsqk
     * 厂商为昆山博浪
     * 传空值时默认120
     */
    private String width;

    /**
     * 签署位置类型
     * PERSON-个人,
     * ORGANIZE-企业,
     * LEGAL-法定代表人,
     * NOLIMIT-不限制;
     * 多个用','隔开,默认NOLIMIT
     */
    private String qswzlx;

    /**
     * 厂商为昆山博浪时，
     * 1：盖章   默认送7：签字
     */
    private String qsfs;

    /**
     * 签名域高度
     * 厂商为昆山博浪
     * qsfs为7时传空值时默认30，
     * 其他默认120
     */
    private String height;


    /**
     * 签署图片base64编码
     */
    private String qsimg;

    /**
     * 印章编码
     */
    private String yzbm;

    /**
     * 印章名称
     */
    private String yzmc;
}
